/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.Helper;

public final class CMessageCooldown {
    private final CooldownType cooldownType;
    private final long worldTime;

    public CMessageCooldown(CooldownType cooldownType, long worldTime) {
        this.cooldownType = cooldownType;
        this.worldTime = worldTime;
    }

    static CMessageCooldown fromBytes(FriendlyByteBuf buf) {
        return new CMessageCooldown(CooldownType.values()[buf.readByte() & 0xFF], buf.readLong());
    }

    static void toBytes(CMessageCooldown msg, FriendlyByteBuf buf) {
        buf.writeByte(msg.cooldownType.ordinal());
        buf.writeLong(msg.worldTime);
    }

    public static class Handler {
        static void handle(final CMessageCooldown message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        CooldownHandler.INSTANCE.updateClientCooldown(message.cooldownType, message.worldTime);
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

