/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.Helper;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PerkRegistry {
    public static final ResourceKey<Registry<Perk>> PERK_RESOURCE_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("tombstone", "perks"));
    private static Supplier<IForgeRegistry<Perk>> perkRegistry = (Supplier)Helper.unsafeNullCast();

    @SubscribeEvent
    public static void createRegistry(NewRegistryEvent event) {
        perkRegistry = event.create(new RegistryBuilder().setName(PERK_RESOURCE_KEY.m_135782_()).setIDRange(0, 512));
    }

    @Nullable
    public static Perk getValue(ResourceLocation rl) {
        return (Perk)perkRegistry.get().getValue(rl);
    }

    @Nullable
    public static Perk getValue(String id) {
        return PerkRegistry.getValue(new ResourceLocation(id));
    }

    @Nullable
    public static Perk getValue(int id) {
        return (Perk)((ForgeRegistry)perkRegistry.get()).getValue(id);
    }

    @Nullable
    public static ResourceLocation getKey(@Nullable Perk perk) {
        return Optional.ofNullable(perk).map(arg_0 -> perkRegistry.get().getKey(arg_0)).orElse(null);
    }

    public static String getStringKey(@Nullable Perk perk) {
        return Optional.ofNullable(PerkRegistry.getKey(perk)).map(ResourceLocation::toString).orElse("");
    }

    public static Collection<Perk> values() {
        return perkRegistry.get().getValues();
    }
}

