/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.Collection;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;

public enum StatusEffectsProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    public static Component getEffectName(MobEffectInstance mobEffectInstance) {
        MutableComponent mutableComponent = mobEffectInstance.m_19544_().m_19482_().m_6881_();
        if (mobEffectInstance.m_19564_() >= 1 && mobEffectInstance.m_19564_() <= 9) {
            mutableComponent.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)("enchantment.level." + (mobEffectInstance.m_19564_() + 1))));
        }
        return mutableComponent;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!accessor.getServerData().m_128441_("StatusEffects")) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        ITooltip box = helper.tooltip();
        ListTag list = accessor.getServerData().m_128437_("StatusEffects", 10);
        Component[] lines = new Component[list.size()];
        for (int i = 0; i < lines.length; ++i) {
            CompoundTag compound = list.m_128728_(i);
            MutableComponent name = Component.Serializer.m_130714_((String)compound.m_128461_("Name"));
            if (name == null) continue;
            String duration = compound.m_128471_("Infinite") ? I18n.m_118938_((String)"effect.duration.infinite", (Object[])new Object[0]) : StringUtil.m_14404_((int)compound.m_128451_("Duration"));
            MutableComponent s = Component.m_237110_((String)"jade.potion", (Object[])new Object[]{name, duration});
            IThemeHelper t = IThemeHelper.get();
            box.add((Component)(compound.m_128471_("Bad") ? t.danger(s) : t.success(s)));
        }
        tooltip.add(helper.box(box, BoxStyle.DEFAULT));
    }

    @Override
    public void appendServerData(CompoundTag tag, EntityAccessor accessor) {
        LivingEntity living = (LivingEntity)accessor.getEntity();
        Collection effects = living.m_21220_();
        if (effects.isEmpty()) {
            return;
        }
        ListTag list = new ListTag();
        for (MobEffectInstance effect : effects) {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("Name", Component.Serializer.m_130703_((Component)StatusEffectsProvider.getEffectName(effect)));
            if (effect.m_267577_()) {
                compound.m_128379_("Infinite", true);
            } else {
                compound.m_128405_("Duration", effect.m_19557_());
            }
            compound.m_128379_("Bad", effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL);
            list.add((Object)compound);
        }
        tag.m_128365_("StatusEffects", (Tag)list);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_POTION_EFFECTS;
    }
}

