/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util;

import common.com.cursee.more_bows_and_arrows.core.world.entity.projectile.ModArrow;
import common.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import common.com.cursee.more_bows_and_arrows.core.world.item.ModBowItem;
import common.com.cursee.more_bows_and_arrows.core.world.item.util.BowType;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

@FunctionalInterface
public interface IModArrow {
    public ArrowType getArrowType();

    default public void processBlockInteraction(ModArrow arrow, BlockHitResult result) {
        Entity owner = arrow.m_19749_();
        Level level = arrow.m_9236_();
        BlockPos pos = result.m_82425_();
        BlockState state = arrow.m_9236_().m_8055_(pos);
        ItemStack stack = owner instanceof LivingEntity ? ((LivingEntity)owner).m_21205_() : ItemStack.f_41583_;
        ModBowItem bow = stack.m_41720_() instanceof ModBowItem ? (ModBowItem)stack.m_41720_() : null;
        switch (this.getArrowType()) {
            case BAMBOO: {
                if (bow == null || bow.getBowType() != BowType.BAMBOO) break;
                IModArrow.bambooArrowHitsBlock(level, pos, state);
                break;
            }
            case BLAZE_ROD: {
                IModArrow.igniteBlockOnHit(result, level, pos, state);
                break;
            }
            case COPPER: {
                LightningBolt lightningBolt;
                if (level.f_46441_.m_188501_() < 0.01f && level.m_46758_(pos)) {
                    lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                    lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_7494_()));
                    lightningBolt.m_20879_(null);
                    level.m_7967_((Entity)lightningBolt);
                }
                if (bow == null || bow.getBowType() != BowType.COPPER) break;
                lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_7494_()));
                lightningBolt.m_20879_(null);
                level.m_7967_((Entity)lightningBolt);
                break;
            }
            case ENDER_PEARL: {
                BlockPos relativePosition = pos.m_121945_(result.m_82434_());
                if (owner == null || arrow.m_9236_().m_5776_()) break;
                owner.m_264318_((ServerLevel)arrow.m_9236_(), (double)relativePosition.m_123341_(), (double)relativePosition.m_123342_(), (double)relativePosition.m_123343_(), RelativeMovement.f_263774_, owner.m_146908_(), owner.m_146909_());
                break;
            }
            case FLINT_AND_STEEL: {
                IModArrow.igniteBlockOnHit(result, level, pos, state);
                break;
            }
            case FLINT: {
                if (bow == null || bow.getBowType() != BowType.IRON) break;
                IModArrow.igniteBlockOnHit(result, level, pos, state);
                break;
            }
            case MOSS: {
                if (bow == null || bow.getBowType() != BowType.MOSS && bow.getBowType() != BowType.PAPER) break;
                IModArrow.paperArrowHitsBlock(owner, level, pos);
                break;
            }
            case PAPER: {
                if (bow == null || bow.getBowType() != BowType.PAPER && bow.getBowType() != BowType.MOSS) break;
                IModArrow.paperArrowHitsBlock(owner, level, pos);
                break;
            }
            case TNT: {
                arrow.m_146870_();
                level.m_255391_(owner, (double)result.m_82425_().m_123341_(), (double)(result.m_82425_().m_123342_() + 1), (double)result.m_82425_().m_123343_(), 2.0f, true, Level.ExplosionInteraction.TNT);
            }
        }
    }

    default public void processEntityInteraction(ModArrow arrow, EntityHitResult result) {
        Player player;
        ModBowItem bow;
        Entity owner = arrow.m_19749_();
        Level level = arrow.m_9236_();
        Entity entity = result.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity hitEntity = (LivingEntity)entity;
        ItemStack stack = owner instanceof LivingEntity ? ((LivingEntity)owner).m_21205_() : ItemStack.f_41583_;
        ModBowItem modBowItem = bow = stack.m_41720_() instanceof ModBowItem ? (ModBowItem)stack.m_41720_() : null;
        if (owner instanceof Player && (player = (Player)owner).m_9236_() != null) {
            hitEntity.f_19802_ = 0;
            hitEntity.m_20331_(false);
            hitEntity.f_20917_ = 0;
            hitEntity.f_20916_ = 0;
            hitEntity.f_19864_ = false;
            player.m_21335_(null);
            hitEntity.m_6703_(null);
            hitEntity.m_6598_(null);
            hitEntity.m_6469_(owner.m_9236_().m_269111_().m_269264_(), this.getArrowType().getAttackDamageBonus());
        } else if (hitEntity instanceof Player) {
            Player player2 = (Player)hitEntity;
            if (owner == null) {
                player2.f_19802_ = 0;
                player2.m_20331_(false);
                player2.f_20917_ = 0;
                player2.f_20916_ = 0;
                player2.f_19864_ = false;
                player2.m_21335_(null);
                player2.m_6703_(null);
                player2.m_6598_(null);
                player2.m_6469_(player2.m_9236_().m_269111_().m_269264_(), this.getArrowType().getAttackDamageBonus());
            }
        }
        switch (this.getArrowType()) {
            case BLAZE_ROD: {
                hitEntity.m_20254_(2);
                break;
            }
            case BONE: {
                hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 20, 1));
                break;
            }
            case COPPER: {
                LightningBolt lightningBolt;
                if (level.f_46441_.m_188501_() < 0.01f && level.m_46758_(hitEntity.m_20183_().m_7494_())) {
                    lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                    lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)hitEntity.m_20183_().m_7494_()));
                    lightningBolt.m_20879_(null);
                    level.m_7967_((Entity)lightningBolt);
                }
                if (bow == null || bow.getBowType() != BowType.COPPER) break;
                lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)hitEntity.m_20183_().m_7494_()));
                lightningBolt.m_20879_(null);
                level.m_7967_((Entity)lightningBolt);
                break;
            }
            case ENDER_PEARL: {
                if (owner == null || arrow.m_9236_().m_5776_()) break;
                hitEntity.m_264318_((ServerLevel)owner.m_9236_(), owner.f_19854_, owner.f_19855_, owner.f_19856_, RelativeMovement.f_263774_, hitEntity.m_146908_(), hitEntity.m_146909_());
                break;
            }
            case FLINT_AND_STEEL: {
                hitEntity.m_20254_(2);
                break;
            }
            case FLINT: {
                if (bow == null || bow.getBowType() != BowType.IRON) break;
                hitEntity.m_20254_(2);
                break;
            }
            case MOSS: {
                if (bow == null || bow.getBowType() != BowType.MOSS && bow.getBowType() != BowType.PAPER) break;
                IModArrow.paperArrowHitsEntity(owner, level, (Entity)hitEntity);
                break;
            }
            case PAPER: {
                if (bow == null || bow.getBowType() != BowType.PAPER && bow.getBowType() != BowType.MOSS) break;
                IModArrow.paperArrowHitsEntity(owner, level, (Entity)hitEntity);
                break;
            }
            case TNT: {
                level.m_255391_(null, hitEntity.f_19854_, hitEntity.f_19855_ + 1.0, hitEntity.f_19856_, 2.0f, true, Level.ExplosionInteraction.TNT);
                arrow.m_146870_();
            }
        }
    }

    private static void igniteBlockOnHit(BlockHitResult result, Level level, BlockPos pos, BlockState state) {
        if (!state.m_61138_((Property)BlockStateProperties.f_61443_)) {
            BlockPos relativePosition = pos.m_121945_(result.m_82434_());
            if (level.m_46859_(relativePosition)) {
                level.m_46597_(relativePosition, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)relativePosition));
            }
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private static void bambooArrowHitsBlock(Level level, BlockPos pos, BlockState state) {
        if (Blocks.f_50571_.m_49966_().m_60710_((LevelReader)level, pos)) {
            if (Feature.m_159759_((BlockState)state)) {
                level.m_7731_(pos, Blocks.f_50599_.m_49966_(), 3);
                level.m_7731_(pos.m_7494_(), Blocks.f_50571_.m_49966_(), 3);
            } else if (state.m_60713_(Blocks.f_50571_)) {
                level.m_7731_(pos.m_7494_(), Blocks.f_50571_.m_49966_(), 3);
            }
        }
    }

    private static void paperArrowHitsBlock(Entity owner, Level level, BlockPos pos) {
        Random random = new Random();
        switch (random.nextInt(1, 9)) {
            case 1: {
                level.m_255391_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2.0f, true, Level.ExplosionInteraction.TNT);
                break;
            }
            case 2: {
                if (owner == null) break;
                owner.m_6021_(owner.f_19854_, owner.f_19855_ + 10.0, owner.f_19856_);
                break;
            }
            case 3: {
                if (owner == null) break;
                owner.m_6021_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                break;
            }
            case 4: {
                if (owner == null) break;
                owner.m_6021_((double)pos.m_123341_(), (double)(pos.m_123342_() + 10), (double)pos.m_123343_());
                break;
            }
            case 5: {
                LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_7494_()));
                lightningBolt.m_20879_(null);
                level.m_7967_((Entity)lightningBolt);
                break;
            }
            case 6: {
                level.m_255391_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.0f, true, Level.ExplosionInteraction.TNT);
                break;
            }
            case 7: {
                for (int i = 0; i < 4; ++i) {
                    Chicken chicken = (Chicken)EntityType.f_20555_.m_20615_(level);
                    chicken.m_6027_((double)pos.m_123341_(), (double)(pos.m_123342_() + i), (double)pos.m_123343_());
                    level.m_7967_((Entity)chicken);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < 4; ++i) {
                    Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_(level);
                    zombie.m_6027_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    level.m_7967_((Entity)zombie);
                }
                break;
            }
        }
    }

    private static void paperArrowHitsEntity(Entity owner, Level level, Entity entity) {
        Random random = new Random();
        switch (random.nextInt(1, 9)) {
            case 1: {
                entity.m_20254_(2);
                break;
            }
            case 2: {
                if (owner == null) break;
                entity.m_6021_(owner.f_19854_, owner.f_19855_, owner.f_19856_);
                break;
            }
            case 3: {
                if (owner == null) break;
                owner.m_6021_(entity.f_19854_, entity.f_19855_, entity.f_19856_);
                break;
            }
            case 4: {
                if (owner == null) break;
                entity.m_6021_(entity.f_19854_, entity.f_19855_ + 10.0, entity.f_19856_);
                break;
            }
            case 5: {
                LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)entity.m_20183_().m_7494_()));
                lightningBolt.m_20879_(null);
                level.m_7967_((Entity)lightningBolt);
                break;
            }
            case 6: {
                level.m_255391_(null, entity.f_19854_, entity.f_19855_, entity.f_19856_, 2.0f, true, Level.ExplosionInteraction.TNT);
                break;
            }
            case 7: {
                for (int i = 0; i < 4; ++i) {
                    Chicken chicken = (Chicken)EntityType.f_20555_.m_20615_(level);
                    chicken.m_6027_(entity.f_19854_, entity.f_19855_ + (double)i, entity.f_19856_);
                    level.m_7967_((Entity)chicken);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < 4; ++i) {
                    Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_(level);
                    zombie.m_6027_(entity.f_19854_, entity.f_19855_, entity.f_19856_);
                    level.m_7967_((Entity)zombie);
                }
                break;
            }
        }
    }
}

