/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.more_bows_and_arrows.core.registry;

import fabric.com.cursee.more_bows_and_arrows.Constants;
import fabric.com.cursee.more_bows_and_arrows.MoreBowsAndArrows;
import fabric.com.cursee.more_bows_and_arrows.core.ModConfig;
import fabric.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import fabric.com.cursee.more_bows_and_arrows.core.world.item.ModArrowItem;
import fabric.com.cursee.more_bows_and_arrows.core.world.item.ModBowItem;
import fabric.com.cursee.more_bows_and_arrows.core.world.item.util.BowType;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public class ModItems {
    public static final LinkedHashMap<ArrowType, class_1792> ARROW_ITEM_FROM_TYPE_MAP = new LinkedHashMap();
    public static final LinkedHashMap<BowType, class_1792> BOW_ITEM_FROM_TYPE_MAP = new LinkedHashMap();
    public static final LinkedList<class_1792> ITEMS_FOR_TAB = new LinkedList();

    public static void register(BiConsumer<class_1792, class_2960> consumer) {
        if (!ModConfig.BANNED_BOWS.isEmpty()) {
            Constants.LOG.info("Some bows were banned: ");
            ModConfig.BANNED_BOWS.forEach(System.out::println);
        }
        for (BowType bowType : BowType.values()) {
            ModBowItem bow = new ModBowItem(bowType, new class_1792.class_1793());
            if (bowType != BowType.NORMAL) {
                ITEMS_FOR_TAB.add((class_1792)bow);
            }
            BOW_ITEM_FROM_TYPE_MAP.put(bowType, (class_1792)bow);
            consumer.accept((class_1792)bow, MoreBowsAndArrows.identifier(bowType.name().toLowerCase() + "_bow"));
        }
        if (ModConfig.BANNED_ARROWS != null && !ModConfig.BANNED_ARROWS.isEmpty()) {
            Constants.LOG.info("Some arrows were banned: ");
            ModConfig.BANNED_ARROWS.forEach(System.out::println);
        }
        for (Enum enum_ : ArrowType.values()) {
            ModArrowItem arrow = new ModArrowItem((ArrowType)enum_, new class_1792.class_1793());
            if (enum_ != ArrowType.NORMAL) {
                ITEMS_FOR_TAB.add((class_1792)arrow);
            }
            ARROW_ITEM_FROM_TYPE_MAP.put((ArrowType)enum_, (class_1792)arrow);
            consumer.accept((class_1792)arrow, MoreBowsAndArrows.identifier(enum_.name().toLowerCase() + "_arrow"));
        }
    }
}

