/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.block.DeskCabinetBlock;
import com.mrcrayfish.furniture.core.ModBlockEntities;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.tileentity.BasicLootBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DeskCabinetBlockEntity
extends BasicLootBlockEntity {
    protected DeskCabinetBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public DeskCabinetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DESK_CABINET.get(), pos, state);
    }

    @Override
    public int m_6643_() {
        return 9;
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.cfm.desk_cabinet");
    }

    @Override
    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return new ChestMenu(MenuType.f_39957_, windowId, playerInventory, (Container)this, 1);
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        this.playDoorSound(state, (SoundEvent)ModSounds.BLOCK_BEDSIDE_CABINET_OPEN.get());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        this.playDoorSound(state, (SoundEvent)ModSounds.BLOCK_BEDSIDE_CABINET_CLOSE.get());
        this.setDoorState(state, false);
    }

    private void playDoorSound(BlockState state, SoundEvent event) {
        Vec3i directionVec = ((Direction)state.m_61143_((Property)DeskCabinetBlock.DIRECTION)).m_122436_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)directionVec.m_123341_() / 2.0;
        double y = (double)this.f_58858_.m_123342_() + 0.5 + (double)directionVec.m_123342_() / 2.0;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)directionVec.m_123343_() / 2.0;
        Level level = this.m_58904_();
        if (level != null) {
            level.m_6263_(null, x, y, z, event, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.m_58904_();
        if (level != null) {
            level.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)DeskCabinetBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }
}

