/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.disenchanting_table.core.world.inventory;

import common.com.cursee.disenchanting_table.core.ServerConfig;
import common.com.cursee.disenchanting_table.core.registry.ModBlocks;
import common.com.cursee.disenchanting_table.core.registry.ModMenus;
import common.com.cursee.disenchanting_table.core.util.DisenchantmentHelper;
import common.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class DisenchantingMenu
extends ItemCombinerMenu {
    public int cost = 0;
    public final DataSlot mayPickup = DataSlot.m_39401_();
    private final Player playerReference;
    @Nullable
    private Enchantment keptEnchantment;
    @Nullable
    private Integer keptEnchantmentLevel;
    @Nullable
    private Map<Enchantment, Integer> stolenEnchantments;

    public DisenchantingMenu(int containerIndex, Inventory inventory) {
        this(containerIndex, inventory, ContainerLevelAccess.f_39287_);
    }

    public DisenchantingMenu(int containerIndex, Inventory inventory, ContainerLevelAccess access) {
        super(ModMenus.DISENCHANTING_MENU, containerIndex, inventory, access);
        this.m_38895_(this.mayPickup);
        this.mayPickup.m_6422_(this.cost);
        this.playerReference = inventory.f_35978_;
    }

    protected boolean m_8039_(BlockState blockState) {
        return blockState.m_60713_(ModBlocks.DISENCHANTING_TABLE);
    }

    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 27, 47, DisenchantmentHelper::canDisenchant).m_266197_(1, 76, 47, stack -> stack.m_150930_(Items.f_42517_)).m_266198_(2, 134, 47).m_266441_();
    }

    public boolean hasResult() {
        return !this.f_39768_.m_7983_();
    }

    private void reset() {
        this.keptEnchantment = null;
        this.keptEnchantmentLevel = null;
        this.stolenEnchantments = null;
        this.f_39768_.m_6836_(0, ItemStack.f_41583_);
        this.cost = 0;
        this.mayPickup.m_6422_(0);
    }

    private void disenchantNormal(ItemStack input) {
        this.keptEnchantment = null;
        this.keptEnchantmentLevel = null;
        this.stolenEnchantments = EnchantmentHelper.m_44831_((ItemStack)input);
        ItemStack result = new ItemStack((ItemLike)Items.f_42690_);
        EnchantmentHelper.m_44865_(this.stolenEnchantments, (ItemStack)result);
        this.f_39768_.m_6836_(0, result);
    }

    private void disenchantBookWithMany(ItemStack input) {
        this.stolenEnchantments = EnchantmentHelper.m_44831_((ItemStack)input);
        this.keptEnchantment = this.stolenEnchantments.keySet().iterator().next();
        this.keptEnchantmentLevel = this.stolenEnchantments.get(this.keptEnchantment);
        this.stolenEnchantments.remove(this.keptEnchantment);
        ItemStack result = new ItemStack((ItemLike)Items.f_42690_);
        EnchantmentHelper.m_44865_(this.stolenEnchantments, (ItemStack)result);
        this.f_39768_.m_6836_(0, result);
    }

    boolean satisfiesCost() {
        Player player = this.playerReference;
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        int currentExperience = ExperienceHelper.getTotalPlayerExperiencePoints((Player)serverPlayer);
        boolean creative = this.f_39771_.m_150110_().f_35937_;
        boolean experiencePoints = ServerConfig.uses_points && currentExperience >= this.cost;
        boolean experienceLevels = !ServerConfig.uses_points && serverPlayer.f_36078_ >= this.cost;
        boolean experience = experiencePoints || experienceLevels;
        boolean books = this.f_39769_.m_8020_(1).m_150930_(Items.f_42517_);
        return (creative || experience) && books;
    }

    public void m_6640_() {
        Player player = this.playerReference;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack input = this.f_39769_.m_8020_(0);
        ItemStack book = this.f_39769_.m_8020_(1);
        if (!DisenchantmentHelper.canDisenchant(input) || !book.m_150930_(Items.f_42517_)) {
            this.reset();
            return;
        }
        if (!input.m_150930_(Items.f_42690_)) {
            this.disenchantNormal(input);
        } else if (EnchantmentHelper.m_44831_((ItemStack)input).size() > 1) {
            this.disenchantBookWithMany(input);
        } else if (EnchantmentHelper.m_44831_((ItemStack)input).size() == 1) {
            ItemStack result = input.m_41777_();
            if (ServerConfig.resets_repair_cost) {
                result.m_41742_(0);
            }
            this.f_39768_.m_6836_(0, result);
        }
        if (!ServerConfig.requires_experience && !this.hasResult()) {
            return;
        }
        boolean requiresExperience = ServerConfig.requires_experience;
        boolean satisfiesCost = this.satisfiesCost();
        this.mayPickup.m_6422_(requiresExperience && satisfiesCost ? 1 : 0);
        this.cost = ServerConfig.experience_cost;
    }

    protected boolean m_6560_(@Nonnull Player player, boolean b) {
        this.mayPickup.m_6422_(this.satisfiesCost() ? 1 : 0);
        return this.mayPickup.m_6501_() == 1;
    }

    protected void m_142365_(Player player, ItemStack itemStack) {
        this.f_39770_.m_39292_((level, blockPos) -> level.m_46796_(1503, blockPos, 0));
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ItemStack input = this.f_39769_.m_8020_(0);
        ItemStack extra = this.f_39769_.m_8020_(1);
        if (!input.m_150930_(Items.f_42690_)) {
            if (ServerConfig.resets_repair_cost) {
                input.m_41742_(0);
            }
            EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)ItemStack.f_41583_), (ItemStack)input);
            this.f_39769_.m_6836_(0, input);
        } else if (input.m_150930_(Items.f_42690_) && EnchantmentHelper.m_44831_((ItemStack)input).size() > 1) {
            if (this.keptEnchantment == null || this.keptEnchantmentLevel == null) {
                return;
            }
            this.f_39769_.m_6836_(0, EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(this.keptEnchantment, this.keptEnchantmentLevel.intValue())));
        } else if (input.m_150930_(Items.f_42690_) && EnchantmentHelper.m_44831_((ItemStack)input).size() == 1) {
            this.f_39769_.m_6836_(0, ItemStack.f_41583_);
        }
        extra.m_41774_(1);
        this.f_39769_.m_6836_(1, extra);
        if (!ServerConfig.requires_experience) {
            return;
        }
        if (ServerConfig.uses_points) {
            player.m_6756_(-ServerConfig.experience_cost);
        } else {
            player.m_6749_(-ServerConfig.experience_cost);
        }
        this.reset();
        if (!input.m_41619_() && input.m_41610_() > 0) {
            this.m_6640_();
        }
    }
}

