/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core.network.packet;

import forge.com.cursee.disenchanting_table.client.network.packet.ForgeConfigSyncClientHandler;
import forge.com.cursee.disenchanting_table.core.ServerConfig;
import forge.com.cursee.disenchanting_table.core.network.ForgeNetwork;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ForgeConfigSyncS2CPacket {
    public final boolean automatic_disenchanting;
    public final boolean resets_repair_cost;
    public final boolean requires_experience;
    public final boolean uses_points;
    public final int experience_cost;

    public ForgeConfigSyncS2CPacket(boolean automatic_disenchanting, boolean resets_repair_cost, boolean requires_experience, boolean uses_points, int experience_cost) {
        this.automatic_disenchanting = automatic_disenchanting;
        this.resets_repair_cost = resets_repair_cost;
        this.requires_experience = requires_experience;
        this.uses_points = uses_points;
        this.experience_cost = experience_cost;
    }

    public void encode(FriendlyByteBuf data) {
        data.writeBoolean(this.automatic_disenchanting);
        data.writeBoolean(this.resets_repair_cost);
        data.writeBoolean(this.requires_experience);
        data.writeBoolean(this.uses_points);
        data.writeInt(this.experience_cost);
    }

    public static ForgeConfigSyncS2CPacket decode(FriendlyByteBuf data) {
        return new ForgeConfigSyncS2CPacket(data.readBoolean(), data.readBoolean(), data.readBoolean(), data.readBoolean(), data.readInt());
    }

    public static void handle(ForgeConfigSyncS2CPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ForgeConfigSyncS2CPacket.lambda$handle$1(packet, (Supplier)contextSupplier)));
        contextSupplier.get().setPacketHandled(true);
    }

    public static void createAndSend(Entity entity, Level level) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ForgeNetwork.sendToPlayer(new ForgeConfigSyncS2CPacket(ServerConfig.automatic_disenchanting, ServerConfig.resets_repair_cost, ServerConfig.requires_experience, ServerConfig.uses_points, ServerConfig.experience_cost), player);
    }

    private static /* synthetic */ Runnable lambda$handle$1(ForgeConfigSyncS2CPacket packet, Supplier contextSupplier) {
        return () -> ForgeConfigSyncS2CPacket.lambda$handle$0(packet, (Supplier)contextSupplier);
    }

    private static /* synthetic */ void lambda$handle$0(ForgeConfigSyncS2CPacket packet, Supplier contextSupplier) {
        ForgeConfigSyncClientHandler.registerS2CPacketHandler(packet, contextSupplier);
    }
}

