/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.platform.Services;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public boolean m_20363_(Entity pEntity) {
        throw new IllegalStateException("EntityMixin application failed");
    }

    @Shadow
    public abstract void m_7340_(Entity var1);

    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPositionPassenger(Entity entity, Entity.MoveFunction move, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player otherPlayer;
            Player thisPlayer = (Player)entityMixin;
            if (entity instanceof Player && this.m_20363_((Entity)(otherPlayer = (Player)entity)) && CarryOnDataManager.getCarryData(thisPlayer).isCarrying(CarryOnData.CarryType.PLAYER)) {
                Vec3 forward = new Vec3(0.0, 0.0, 0.6);
                Vec3 otherPos = thisPlayer.m_20182_().m_82549_(forward.m_82524_((float)Math.toRadians(-thisPlayer.f_20883_)));
                otherPos = otherPos.m_82520_(0.0, 0.4, 0.0);
                move.m_20372_((Entity)otherPlayer, otherPos.f_82479_, otherPos.f_82480_, otherPos.f_82481_);
                ((Entity)this).m_7340_((Entity)otherPlayer);
                ci.cancel();
            }
        }
    }

    @Inject(method={"getDismountLocationForPassenger(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")})
    private void onDismountPassenger(LivingEntity living, CallbackInfoReturnable<Vec3> cir) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player thisPlayer = (Player)entityMixin;
            if (living instanceof Player) {
                Player otherPlayer = (Player)living;
                CarryOnData carry = CarryOnDataManager.getCarryData(thisPlayer);
                if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
                    carry.clear();
                    CarryOnDataManager.setCarryData(thisPlayer, carry);
                    Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_START_RIDING, new ClientboundStartRidingPacket(otherPlayer.m_19879_(), false), (ServerPlayer)thisPlayer);
                }
            }
        }
    }

    @Inject(method={"onPassengerTurned(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void onPassengerTurned(Entity toUpdate, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player thisPlayer = (Player)entityMixin;
            if (toUpdate instanceof Player) {
                Player otherPlayer = (Player)toUpdate;
                CarryOnData carry = CarryOnDataManager.getCarryData(thisPlayer);
                if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
                    this.clampRotation(toUpdate);
                }
            }
        }
    }

    @Unique
    private void clampRotation(Entity pEntityToUpdate) {
        Entity thisEntity = (Entity)this;
        pEntityToUpdate.m_5618_(thisEntity.m_146908_());
        float f = Mth.m_14177_((float)(pEntityToUpdate.m_146908_() - thisEntity.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-30.0f, (float)30.0f);
        pEntityToUpdate.f_19859_ += f1 - f;
        pEntityToUpdate.m_146922_(pEntityToUpdate.m_146908_() + f1 - f);
        pEntityToUpdate.m_5616_(pEntityToUpdate.m_146908_());
    }
}

