/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.crabclaws;

import dev.foxgirl.crabclaws.CrabclawsConfig;
import dev.foxgirl.crabclaws.CrabclawsModItems;
import dev.foxgirl.crabclaws.CrabclawsModTabs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crabclaws")
public class CrabclawsMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final CrabclawsConfig CONFIG = CrabclawsConfig.loadConfig();
    private static final ResourceLocation UNDERWATER_RUIN_SMALL = new ResourceLocation("minecraft:chests/underwater_ruin_small");
    private static final ResourceLocation UNDERWATER_RUIN_BIG = new ResourceLocation("minecraft:chests/underwater_ruin_big");

    public CrabclawsMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CrabclawsModItems.REGISTRY.register(bus);
        CrabclawsModTabs.REGISTRY.register(bus);
        MinecraftForge.EVENT_BUS.addListener(this::onLootTableLoad);
    }

    public void onLootTableLoad(LootTableLoadEvent event) {
        if (CrabclawsMod.CONFIG.shouldSpawnClawsInRuins && (event.getName().equals((Object)UNDERWATER_RUIN_SMALL) || event.getName().equals((Object)UNDERWATER_RUIN_BIG))) {
            event.getTable().addPool(LootPool.m_79043_().name("crabclaws:crab_claw").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(CrabclawsMod.CONFIG.probabilityOfClawsInRuins)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)CrabclawsModItems.CRAB_CLAW.get())).m_79707_(1)).m_79082_());
            LOGGER.info("Added crab claw loot pool to {}", (Object)event.getName());
        }
    }
}

