/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation;

import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.capability.BarteringStationCapability;
import fuzs.barteringstation.data.ModBlockLootProvider;
import fuzs.barteringstation.data.ModBlockStateProvider;
import fuzs.barteringstation.data.ModBlockTagsProvider;
import fuzs.barteringstation.data.ModLanguageProvider;
import fuzs.barteringstation.data.ModRecipeProvider;
import fuzs.barteringstation.init.ForgeModRegistry;
import fuzs.barteringstation.init.ModRegistry;
import fuzs.puzzleslib.api.capability.v2.ForgeCapabilityHelper;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="barteringstation")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BarteringStationForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        ModConstructor.construct((String)"barteringstation", BarteringStation::new, (ContentRegistrationFlags[])new ContentRegistrationFlags[0]);
        ForgeModRegistry.touch();
        BarteringStationForge.registerCapabilities();
    }

    private static void registerCapabilities() {
        ForgeCapabilityHelper.setCapabilityToken(ModRegistry.BARTERING_STATION_CAPABILITY, (CapabilityToken)new CapabilityToken<BarteringStationCapability>(){});
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator dataGenerator = evt.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = evt.getLookupProvider();
        ExistingFileHelper fileHelper = evt.getExistingFileHelper();
        dataGenerator.addProvider(true, (DataProvider)new ModBlockLootProvider(packOutput, "barteringstation"));
        dataGenerator.addProvider(true, (DataProvider)new ModBlockStateProvider(packOutput, "barteringstation", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModBlockTagsProvider(packOutput, lookupProvider, "barteringstation", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModLanguageProvider(packOutput, "barteringstation"));
        dataGenerator.addProvider(true, (DataProvider)new ModRecipeProvider(packOutput));
    }
}

