/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.exclusive_weapons.registry.item;

import com.cerbon.exclusive_weapons.item.custom.AxeItem;
import com.cerbon.exclusive_weapons.item.custom.HoeItem;
import com.cerbon.exclusive_weapons.item.custom.PickaxeItem;
import com.cerbon.exclusive_weapons.registry.RegistryEntry;
import com.cerbon.exclusive_weapons.registry.ResourcefulRegistries;
import com.cerbon.exclusive_weapons.registry.ResourcefulRegistry;
import com.cerbon.exclusive_weapons.registry.item.ToolType;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;

public class ItemRegistry {
    private final ResourcefulRegistry<Item> itemRegistry;

    public ItemRegistry(String modId) {
        this.itemRegistry = ResourcefulRegistries.create(BuiltInRegistries.f_257033_, modId);
    }

    public Map<ArmorItem.Type, RegistryEntry<ArmorItem>> registerFullArmorSet(ArmorMaterial material, String materialName) {
        return this.registerFullArmorSet(material, properties -> properties, materialName);
    }

    public Map<ArmorItem.Type, RegistryEntry<ArmorItem>> registerFullArmorSet(ArmorMaterial material, UnaryOperator<Item.Properties> itemProperties, String materialName) {
        return ImmutableMap.of((Object)ArmorItem.Type.HELMET, this.registerArmor(ArmorItem.Type.HELMET, material, itemProperties, materialName), (Object)ArmorItem.Type.CHESTPLATE, this.registerArmor(ArmorItem.Type.CHESTPLATE, material, itemProperties, materialName), (Object)ArmorItem.Type.LEGGINGS, this.registerArmor(ArmorItem.Type.LEGGINGS, material, itemProperties, materialName), (Object)ArmorItem.Type.BOOTS, this.registerArmor(ArmorItem.Type.BOOTS, material, itemProperties, materialName));
    }

    public RegistryEntry<ArmorItem> registerArmor(ArmorItem.Type armorType, ArmorMaterial material, String materialName) {
        return this.registerArmor(armorType, material, properties -> properties, materialName);
    }

    public RegistryEntry<ArmorItem> registerArmor(ArmorItem.Type armorType, ArmorMaterial material, UnaryOperator<Item.Properties> itemProperties, String materialName) {
        return this.registerItem(() -> new ArmorItem(material, armorType, (Item.Properties)itemProperties.apply(new Item.Properties().m_41503_(material.m_266425_(armorType)))), materialName + "_" + armorType.m_266355_());
    }

    public RegistryEntry<TieredItem> registerSimpleTool(ToolType toolType, Tier tier, float attackDamage, float attackSpeed, String id) {
        return this.registerSimpleTool(toolType, tier, properties -> properties, attackDamage, attackSpeed, id);
    }

    public RegistryEntry<TieredItem> registerSimpleTool(ToolType toolType, Tier tier, UnaryOperator<Item.Properties> itemProperties, float attackDamage, float attackSpeed, String id) {
        return switch (toolType) {
            default -> throw new IncompatibleClassChangeError();
            case ToolType.SWORD -> this.registerItem(() -> new SwordItem(tier, (int)attackDamage, attackSpeed, (Item.Properties)itemProperties.apply(new Item.Properties())), id);
            case ToolType.PICKAXE -> this.registerItem(() -> new PickaxeItem(tier, (int)attackDamage, attackSpeed, (Item.Properties)itemProperties.apply(new Item.Properties())), id);
            case ToolType.AXE -> this.registerItem(() -> new AxeItem(tier, attackDamage, attackSpeed, (Item.Properties)itemProperties.apply(new Item.Properties())), id);
            case ToolType.SHOVEL -> this.registerItem(() -> new ShovelItem(tier, attackDamage, attackSpeed, (Item.Properties)itemProperties.apply(new Item.Properties())), id);
            case ToolType.HOE -> this.registerItem(() -> new HoeItem(tier, (int)attackDamage, attackSpeed, (Item.Properties)itemProperties.apply(new Item.Properties())), id);
        };
    }

    public RegistryEntry<Item> registerFood(FoodProperties foodProperties, String id) {
        return this.registerFood(foodProperties, properties -> properties, id);
    }

    public RegistryEntry<Item> registerFood(FoodProperties foodProperties, UnaryOperator<Item.Properties> itemProperties, String id) {
        return this.registerItem((Item.Properties)itemProperties.apply(new Item.Properties().m_41489_(foodProperties)), id);
    }

    public RegistryEntry<BlockItem> registerBlockItem(Supplier<Block> block, String id) {
        return this.registerBlockItem(block, new Item.Properties(), id);
    }

    public RegistryEntry<BlockItem> registerBlockItem(Supplier<Block> block, Item.Properties itemProperties, String id) {
        return this.registerBlockItem(id, () -> new BlockItem((Block)block.get(), itemProperties));
    }

    public RegistryEntry<BlockItem> registerBlockItem(String id, Supplier<BlockItem> blockItem) {
        return this.registerItem(blockItem, id);
    }

    public RegistryEntry<Item> registerItem(String id) {
        return this.registerItem(new Item.Properties(), id);
    }

    public RegistryEntry<Item> registerItem(Item.Properties itemProperties, String id) {
        return this.registerItem(() -> new Item(itemProperties), id);
    }

    public <T extends Item> RegistryEntry<T> registerItem(Supplier<T> item, String id) {
        return this.itemRegistry.register(id, item);
    }

    public Collection<RegistryEntry<Item>> getEntries() {
        return this.itemRegistry.getEntries();
    }

    public Stream<RegistryEntry<Item>> stream() {
        return this.itemRegistry.stream();
    }

    public Stream<Item> boundStream() {
        return this.itemRegistry.boundStream();
    }

    public void register() {
        this.itemRegistry.register();
    }
}

