/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.command;

import com.cursee.monolib.core.CommonConfigValues;
import com.cursee.monolib.core.command.hand.HandArgument;
import com.cursee.monolib.core.command.hand.HandArgumentHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class MonoLibCommands {
    public static void defineCommands(CommandDispatcher<CommandSourceStack> commandDispatcher, CommandBuildContext commandContext, Commands.CommandSelection commandEnvironment) {
        LiteralArgumentBuilder root = Commands.m_82127_((String)"monolib");
        ((LiteralArgumentBuilder)root.requires(MonoLibCommands::isPlayerOperator)).executes(context -> MonoLibCommands.showCommandHelp((CommandSourceStack)context.getSource()));
        root.then(MonoLibCommands.questionMark());
        root.then(MonoLibCommands.help());
        root.then(MonoLibCommands.debug());
        root.then(MonoLibCommands.hand());
        commandDispatcher.register(root);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> questionMark() {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"?");
        command.executes(commandContext -> MonoLibCommands.showCommandHelp((CommandSourceStack)commandContext.getSource()));
        return command;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> help() {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"help");
        command.executes(commandContext -> MonoLibCommands.showCommandHelp((CommandSourceStack)commandContext.getSource()));
        return command;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> debug() {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"debug");
        command.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            CommonConfigValues.enable_debugging = !CommonConfigValues.enable_debugging;
            player.m_213846_((Component)Component.m_237113_((String)("MonoLib enable_debugging: " + CommonConfigValues.enable_debugging)));
            return 1;
        });
        return command;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> hand() {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"hand");
        command.then(HandArgument.arg().executes(HandArgumentHelper::printHeldStack));
        return command;
    }

    public static int showCommandHelp(CommandSourceStack source) {
        if (MonoLibCommands.isPlayerOperator(source) && source.m_230896_() != null) {
            source.m_230896_().m_213846_((Component)Component.m_237113_((String)"/monolib debug"));
            source.m_230896_().m_213846_((Component)Component.m_237113_((String)" - Toggles MonoLib's debugging value. (Chat Spam Likely)"));
        }
        return 1;
    }

    public static boolean isPlayerOperator(CommandSourceStack source) {
        boolean isPlayer = source.m_230897_();
        ServerPlayer player = source.m_230896_();
        MinecraftServer server = source.m_81377_();
        return isPlayer && player != null && source.m_6761_(server.m_7022_());
    }
}

