/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation.registry;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.util.registry.FilteredHandlerRegistry;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.map.HashMapList;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiRegistryTagHandler {
    public static final FilteredHandlerRegistry<Registry, GuiRegistryTagHandler> REGISTRY = new FilteredHandlerRegistry(new GuiRegistryTagHandler(){

        @Override
        public void createControls(GuiParent parent, Registry registry) {
            parent.add((GuiControl)new GuiComboBoxMapped<ResourceLocation>("elements", new TextMapBuilder<ResourceLocation>().addComponent(registry.m_203613_().iterator(), x -> {
                if (x.m_135827_().equals("minecraft")) {
                    return Component.m_237113_((String)x.m_135815_());
                }
                return Component.m_237113_((String)x.toString());
            })));
        }

        @Override
        public void loadValue(GuiParent parent, Registry registry, TagKey tag) {
            GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("elements");
            box.select(tag.f_203868_());
        }

        @Override
        public TagKey saveValue(GuiParent parent, Registry registry) {
            GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("elements");
            return TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)((ResourceLocation)box.getSelected()));
        }
    });

    public abstract void createControls(GuiParent var1, Registry var2);

    public abstract void loadValue(GuiParent var1, Registry var2, TagKey var3);

    public abstract TagKey saveValue(GuiParent var1, Registry var2);

    static {
        REGISTRY.register((Registry)BuiltInRegistries.f_256975_, new GuiRegistryTagHandler(){
            private static final RandomSource RANDOM = RandomSource.m_216327_();

            @Override
            public void createControls(GuiParent parent, final Registry registry) {
                parent.add((GuiControl)new GuiStackSelector("content", null, new GuiStackSelector.StackCollector(new GuiStackSelector.GuiBlockSelector()){

                    @Override
                    public HashMapList<String, ItemStack> collect(Player player) {
                        HashMapList<String, ItemStack> map = new HashMapList<String, ItemStack>();
                        Iterator iterator = registry.m_203612_().iterator();
                        while (iterator.hasNext()) {
                            Pair pair = (Pair)iterator.next();
                            Optional o = ((HolderSet.Named)pair.getSecond()).m_213653_(RANDOM);
                            if (o.isEmpty()) continue;
                            ItemStack stack = new ItemStack((ItemLike)((Holder)o.get()).m_203334_());
                            if (stack.m_41619_()) {
                                stack = new ItemStack((ItemLike)Blocks.f_50375_);
                            }
                            stack.m_41714_((Component)Component.m_237113_((String)((TagKey)pair.getFirst()).f_203868_().toString()));
                            map.add("tags", stack);
                        }
                        return map;
                    }
                }));
            }

            private String getName(ItemStack stack) {
                MutableComponent comp = (MutableComponent)stack.m_41786_();
                return ((LiteralContents)comp.m_214077_()).f_237368_();
            }

            @Override
            public void loadValue(GuiParent parent, Registry registry, TagKey tag) {
                GuiStackSelector selector = (GuiStackSelector)parent.get("content");
                String text = tag.f_203868_().toString();
                for (ArrayList<ItemStack> stacks : selector.getStacks().values()) {
                    for (ItemStack stack : stacks) {
                        if (!this.getName(stack).equals(text)) continue;
                        selector.setSelectedForce(stack);
                        return;
                    }
                }
                Optional o = registry.m_203431_(tag).flatMap(x -> ((HolderSet.Named)x).m_213653_(RANDOM));
                if (o.isEmpty()) {
                    return;
                }
                ItemStack stack = new ItemStack((ItemLike)((Holder)o.get()).m_203334_());
                stack.m_41714_((Component)Component.m_237113_((String)tag.f_203868_().toString()));
                selector.setSelectedForce(stack);
            }

            @Override
            public TagKey saveValue(GuiParent parent, Registry registry) {
                GuiStackSelector selector = (GuiStackSelector)parent.get("content");
                return TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)new ResourceLocation(this.getName(selector.getSelected())));
            }
        });
    }
}

