/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.roofs;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class Roofs {
    public static final String modid = "mcwroofs";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Roofs.setRegistrationWoodModLoaded(set, block, item, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_));
    }

    public static void setRegistrationRock(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Roofs.setRegistrationRockModLoaded(rock, block, item, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50064_));
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.ROOFS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("StairsBlock")) {
                    CreateBlockReferences.createBlock(id, () -> new StairBlock(() -> ((Block)Blocks.f_50705_).m_49966_(), WOOD), block, item);
                    continue;
                }
                if (isModMcwLoaded) {
                    if (blockId.reflectedLocation().contains("Lower") || blockId.reflectedLocation().contains("Steep")) {
                        CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD, Blocks.f_50705_.m_49966_()), block, item);
                        continue;
                    }
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new Block(WOOD), block, item);
            }
        }
    }

    public static void setRegistrationRockModLoaded(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : rock) {
            for (BlockId blockId : McwBlocksIdBase.ROOFS_STONE_BLOCKS.blocks()) {
                RegistryObject<Block> blockObj;
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("StairsBlock")) {
                    blockObj = CreateBlockReferences.createBlockStone(id, () -> new StairBlock(() -> ((Block)Blocks.f_50652_).m_49966_(), STONE), block, item);
                    continue;
                }
                if (isModMcwLoaded) {
                    if (blockId.reflectedLocation().contains("Lower") || blockId.reflectedLocation().contains("Steep")) {
                        blockObj = CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE, Blocks.f_50652_.m_49966_()), block, item);
                        continue;
                    }
                    blockObj = CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item);
                    continue;
                }
                RegistryObject<Block> registryObject = CreateBlockReferences.createBlockStone(id, () -> new Block(STONE), block, item);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        Roofs.addToTabModLoaded(event, MODID, WOOD, tab, "minecraft");
    }

    @Deprecated(forRemoval=true)
    public static void addToTabModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : WOOD) {
                Block cherry_roof = Finder.findBlock(MODID, i + "_roof");
                Block cherry_attic_roof = Finder.findBlock(MODID, i + "_attic_roof");
                Block cherry_top_roof = Finder.findBlock(MODID, i + "_top_roof");
                Block cherry_lower_roof = Finder.findBlock(MODID, i + "_lower_roof");
                Block cherry_steep_roof = Finder.findBlock(MODID, i + "_steep_roof");
                Block cherry_upper_lower_roof = Finder.findBlock(MODID, i + "_upper_lower_roof");
                Block cherry_upper_steep_roof = Finder.findBlock(MODID, i + "_upper_steep_roof");
                event.m_246326_((ItemLike)cherry_roof);
                event.m_246326_((ItemLike)cherry_attic_roof);
                event.m_246326_((ItemLike)cherry_top_roof);
                event.m_246326_((ItemLike)cherry_lower_roof);
                event.m_246326_((ItemLike)cherry_steep_roof);
                event.m_246326_((ItemLike)cherry_upper_lower_roof);
                event.m_246326_((ItemLike)cherry_upper_steep_roof);
                Block cherry_planks_roof = Finder.findBlock(MODID, i + "_planks_roof");
                Block cherry_planks_attic_roof = Finder.findBlock(MODID, i + "_planks_attic_roof");
                Block cherry_planks_top_roof = Finder.findBlock(MODID, i + "_planks_top_roof");
                Block cherry_planks_lower_roof = Finder.findBlock(MODID, i + "_planks_lower_roof");
                Block cherry_planks_steep_roof = Finder.findBlock(MODID, i + "_planks_steep_roof");
                Block cherry_planks_upper_lower_roof = Finder.findBlock(MODID, i + "_planks_upper_lower_roof");
                Block cherry_planks_upper_steep_roof = Finder.findBlock(MODID, i + "_planks_upper_steep_roof");
                event.m_246326_((ItemLike)cherry_planks_roof);
                event.m_246326_((ItemLike)cherry_planks_attic_roof);
                event.m_246326_((ItemLike)cherry_planks_top_roof);
                event.m_246326_((ItemLike)cherry_planks_lower_roof);
                event.m_246326_((ItemLike)cherry_planks_steep_roof);
                event.m_246326_((ItemLike)cherry_planks_upper_lower_roof);
                event.m_246326_((ItemLike)cherry_planks_upper_steep_roof);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTabStone(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab) {
        Roofs.addToTabStoneModLoaded(event, MODID, STONE, tab, "minecraft");
    }

    @Deprecated(forRemoval=true)
    public static void addToTabStoneModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : STONE) {
                Block ROOF = Finder.findBlock(MODID, i + "_roof");
                Block ATTIC_ROOF = Finder.findBlock(MODID, i + "_attic_roof");
                Block TOP_ROOF = Finder.findBlock(MODID, i + "_top_roof");
                Block LOWER_ROOF = Finder.findBlock(MODID, i + "_lower_roof");
                Block STEEP_ROOF = Finder.findBlock(MODID, i + "_steep_roof");
                Block UPPER_LOWER_ROOF = Finder.findBlock(MODID, i + "_upper_lower_roof");
                Block UPPER_STEEP_ROOF = Finder.findBlock(MODID, i + "_upper_steep_roof");
                event.m_246326_((ItemLike)ROOF);
                event.m_246326_((ItemLike)ATTIC_ROOF);
                event.m_246326_((ItemLike)TOP_ROOF);
                event.m_246326_((ItemLike)LOWER_ROOF);
                event.m_246326_((ItemLike)STEEP_ROOF);
                event.m_246326_((ItemLike)UPPER_LOWER_ROOF);
                event.m_246326_((ItemLike)UPPER_STEEP_ROOF);
            }
        }
    }
}

