/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxencedc.sparsestructures.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.github.maxencedc.sparsestructures.Constants;
import io.github.maxencedc.sparsestructures.StructureSetsSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class DumpStructureSetsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dumpstructuresets").requires(cs -> cs.m_6761_(2))).executes(context -> {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Dumping structure set..."), false);
            String fileName = new SimpleDateFormat("'structure_sets_dump_'yy_MM_dd_HH_mm'.txt'").format(new Date());
            try {
                DumpStructureSetsCommand.dumpStructureSets(fileName);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> {
                    boolean isDedicatedServer = ((CommandSourceStack)context.getSource()).m_81377_().m_6982_();
                    String fileLocation = Paths.get("sparsestructures", fileName).toString();
                    String message = "Structure sets dumped to: `" + fileLocation + "`";
                    if (isDedicatedServer) {
                        message = message + "\n(you can find the result in the server's files)";
                    }
                    return Component.m_237113_((String)message);
                }, false);
                return 1;
            }
            catch (IOException e) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Failed to dump structure sets, check logs for error"), false);
                Constants.LOG.error("Failed to dump structure sets\n", (Throwable)e);
                return 0;
            }
        }));
    }

    private static void dumpStructureSets(String fileName) throws IOException {
        Path dumpPath = Path.of("sparsestructures", new String[0]);
        StringBuilder dump = new StringBuilder();
        StructureSetsSet.structureSets.forEach(s -> dump.append("{\n  \"structure\": \"").append((String)s).append("\",\n  \"factor\": 1//REPLACE WITH YOUR CUSTOM SPREADING FACTOR HERE\n},\n"));
        Files.createDirectories(dumpPath, new FileAttribute[0]);
        Files.writeString(dumpPath.resolve(fileName), (CharSequence)dump.toString(), new OpenOption[0]);
    }
}

