/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DripstoneSplatterFeature
extends Feature<NoneFeatureConfiguration> {
    public DripstoneSplatterFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel worldIn = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos pos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        int i = 0;
        int j = rand.m_188503_(6) + 2;
        for (int k = pos.m_123341_() - j; k <= pos.m_123341_() + j; ++k) {
            block1: for (int l = pos.m_123343_() - j; l <= pos.m_123343_() + j; ++l) {
                int j1;
                int i1 = k - pos.m_123341_();
                if (i1 * i1 + (j1 = l - pos.m_123343_()) * j1 > j * j) continue;
                for (int k1 = pos.m_123342_() - 2; k1 <= pos.m_123342_() + 2; ++k1) {
                    BlockPos blockpos = new BlockPos(k, k1, l);
                    BlockState blockstate = worldIn.m_8055_(blockpos);
                    if (blockstate.m_60734_() != Blocks.f_50440_) continue;
                    if (!DripstoneSplatterFeature.isAir((LevelSimulatedReader)worldIn, blockpos.m_7494_())) continue;
                    worldIn.m_7731_(blockpos, Blocks.f_152537_.m_49966_(), 2);
                    if (rand.m_188503_(5) == 0) {
                        int height = 1 + rand.m_188503_(8);
                        DripstoneSplatterFeature.growPointedDripstone((LevelAccessor)worldIn, blockpos.m_7494_(), Direction.UP, height, false);
                    }
                    ++i;
                    continue block1;
                }
            }
        }
        return i > 0;
    }

    protected static void growPointedDripstone(LevelAccessor p_190848_, BlockPos p_190849_, Direction p_190850_, int p_190851_, boolean p_190852_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_190849_.m_122032_();
        DripstoneSplatterFeature.buildBaseToTipColumn(p_190850_, p_190851_, p_190852_, p_309326_ -> {
            if (p_309326_.m_60713_(Blocks.f_152588_)) {
                p_309326_ = (BlockState)p_309326_.m_61124_((Property)PointedDripstoneBlock.f_154011_, (Comparable)Boolean.valueOf(p_190848_.m_46801_((BlockPos)blockpos$mutableblockpos)));
            }
            p_190848_.m_7731_((BlockPos)blockpos$mutableblockpos, p_309326_, 2);
            blockpos$mutableblockpos.m_122173_(p_190850_);
        });
    }

    protected static void buildBaseToTipColumn(Direction p_159652_, int p_159653_, boolean p_159654_, Consumer<BlockState> p_159655_) {
        if (p_159653_ >= 3) {
            p_159655_.accept(DripstoneSplatterFeature.createPointedDripstone(p_159652_, DripstoneThickness.BASE));
            for (int i = 0; i < p_159653_ - 3; ++i) {
                p_159655_.accept(DripstoneSplatterFeature.createPointedDripstone(p_159652_, DripstoneThickness.MIDDLE));
            }
        }
        if (p_159653_ >= 2) {
            p_159655_.accept(DripstoneSplatterFeature.createPointedDripstone(p_159652_, DripstoneThickness.FRUSTUM));
        }
        if (p_159653_ >= 1) {
            p_159655_.accept(DripstoneSplatterFeature.createPointedDripstone(p_159652_, p_159654_ ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    private static BlockState createPointedDripstone(Direction p_159657_, DripstoneThickness p_159658_) {
        return (BlockState)((BlockState)Blocks.f_152588_.m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)p_159657_)).m_61124_((Property)PointedDripstoneBlock.f_154010_, (Comparable)p_159658_);
    }

    public static boolean isAir(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }
}

