/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class HugeGlowshroomFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.m_8055_(pos).m_60734_() == Blocks.f_50440_ || world.m_8055_(pos).m_60734_() == Blocks.f_50195_ || world.m_8055_(pos).m_60734_() == Blocks.f_50069_ || world.m_8055_(pos).m_60734_() == Blocks.f_152550_ || world.m_8055_(pos).m_60734_() == BOPBlocks.GLOWING_MOSS_BLOCK || world.m_8055_(pos).m_60734_() == Blocks.f_220864_;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_60734_() instanceof BushBlock || world.m_8055_(pos).m_60734_() == BOPBlocks.GLOWING_MOSS_CARPET || world.m_8055_(pos).m_60734_() == Blocks.f_152543_;

    public HugeGlowshroomFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        int z;
        int x;
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        while (startPos.m_123342_() >= world.m_141937_() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos.m_7918_(0, 0, 0))) {
            return false;
        }
        if (!this.checkSpace(world, startPos.m_7494_())) {
            return false;
        }
        BlockPos pos = startPos.m_7494_();
        int height = 6 + rand.m_188503_(10);
        int radius = 2 + rand.m_188503_(2);
        for (int y = 0; y < height; ++y) {
            this.setBlock(world, pos.m_6630_(y), Blocks.f_50182_.m_49966_());
        }
        for (x = -(radius - 1); x <= radius - 1; ++x) {
            for (z = -(radius - 1); z <= radius - 1; ++z) {
                this.setBlock(world, pos.m_7918_(x, height, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)));
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (z = -radius; z <= radius; ++z) {
                if ((x == -radius || x == radius) && (z == -radius || z == radius)) continue;
                if (x == radius) {
                    this.setBlock(world, pos.m_7918_(x, height - 1, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(false)));
                    this.setBlock(world, pos.m_7918_(x, height - 2, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(false)));
                }
                if (x == -radius) {
                    this.setBlock(world, pos.m_7918_(x, height - 1, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(false)));
                    this.setBlock(world, pos.m_7918_(x, height - 2, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(false)));
                }
                if (z == radius) {
                    this.setBlock(world, pos.m_7918_(x, height - 1, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(false)));
                    this.setBlock(world, pos.m_7918_(x, height - 2, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(false)));
                }
                if (z != -radius) continue;
                this.setBlock(world, pos.m_7918_(x, height - 1, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(false)));
                this.setBlock(world, pos.m_7918_(x, height - 2, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(false)));
            }
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos) {
        for (int y = 0; y <= 12; ++y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

