/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModBlockColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModItemColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackBlockEntityRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackDynamicModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackLayerRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.ClientBackpackContentsTooltip;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BlockPickMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SBPPacketHandler;

public class ClientEventHandler {
    private static final String BACKPACK_REG_NAME = "backpack";
    public static final ModelLayerLocation BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("sophisticatedbackpacks", "backpack"), "main");

    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientEventHandler::onModelRegistry);
        modBus.addListener(ClientEventHandler::registerLayer);
        modBus.addListener(ClientEventHandler::registerEntityRenderers);
        modBus.addListener(ClientEventHandler::registerReloadListener);
        modBus.addListener(ModItemColors::registerItemColorHandlers);
        modBus.addListener(ModBlockColors::registerBlockColorHandlers);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientBackpackContentsTooltip::onWorldLoad);
        eventBus.addListener(ClientEventHandler::handleBlockPick);
    }

    private static void onModelRegistry(ModelEvent.RegisterGeometryLoaders event) {
        event.register(BACKPACK_REG_NAME, (IGeometryLoader)BackpackDynamicModel.Loader.INSTANCE);
    }

    public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> ClientEventHandler.registerBackpackLayer()));
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModItems.EVERLASTING_BACKPACK_ITEM_ENTITY.get(), ItemEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.BACKPACK_TILE_TYPE.get(), context -> new BackpackBlockEntityRenderer());
    }

    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BACKPACK_LAYER, BackpackModel::createBodyLayer);
    }

    private static void registerBackpackLayer() {
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        Map skinMap = renderManager.getSkinMap();
        for (EntityRenderer renderer : skinMap.values()) {
            if (!(renderer instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
            livingEntityRenderer.m_115326_(new BackpackLayerRenderer(livingEntityRenderer));
        }
        renderManager.f_114362_.forEach((e, r) -> {
            if (r instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)r;
                livingEntityRenderer.m_115326_(new BackpackLayerRenderer(livingEntityRenderer));
            }
        });
    }

    public static void handleBlockPick(InputEvent.InteractionKeyMappingTriggered event) {
        BlockPos pos;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_7500_() || !event.isPickBlock() || mc.f_91077_ == null || mc.f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        HitResult target = mc.f_91077_;
        Level level = player.m_9236_();
        BlockState state = level.m_8055_(pos = ((BlockHitResult)target).m_82425_());
        if (state.m_60795_()) {
            return;
        }
        ItemStack result = state.getCloneItemStack(target, (BlockGetter)level, pos, (Player)player);
        if (result.m_41619_() || player.m_150109_().m_36030_(result) > -1) {
            return;
        }
        SBPPacketHandler.INSTANCE.sendToServer(new BlockPickMessage(result));
    }
}

