/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.impl.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlanetModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private final ModelPart largePlanet;
    private final ModelPart smallPlanet;

    public PlanetModel(LayerDefinition definition) {
        ModelPart root = definition.m_171564_();
        this.largePlanet = root.m_171324_("large");
        this.smallPlanet = root.m_171324_("small");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        root.m_171599_("large", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -36.0f, -2.0f, 4.0f, 4.0f, 4.0f).m_171514_(-9, 8).m_171481_(-4.5f, -34.0f, -4.5f, 9.0f, 0.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-20.0f));
        root.m_171599_("small", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-1.5f, -35.0f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)16.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.largePlanet, (Object)this.smallPlanet);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.largePlanet.f_104204_ = -ageInTicks / 10.0f;
        this.smallPlanet.f_104204_ = -ageInTicks / 6.0f;
    }
}

