/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceFilterSection;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;
import snownee.kiwi.Kiwi;

public class KiwiPackResourceManager
implements CloseableResourceManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, FallbackResourceManager> namespacedManagers;
    private final List<PackResources> packs;

    public KiwiPackResourceManager(List<PackResources> packs) {
        this.packs = packs.stream().filter(pack -> {
            if (pack.m_5698_(PackType.CLIENT_RESOURCES) == null) {
                Kiwi.LOGGER.error("Pack {}({}) has null namespaces", (Object)pack.m_5542_(), pack.getClass());
                return false;
            }
            return true;
        }).toList();
        packs = this.packs;
        HashMap<String, FallbackResourceManager> map = new HashMap<String, FallbackResourceManager>();
        List list = packs.stream().flatMap(pack -> pack.m_5698_(PackType.CLIENT_RESOURCES).stream()).distinct().toList();
        for (PackResources packresources : packs) {
            ResourceFilterSection resourcefiltersection = this.getPackFilterSection(packresources);
            Set set = packresources.m_5698_(PackType.CLIENT_RESOURCES);
            Predicate<ResourceLocation> predicate = resourcefiltersection != null ? p_215474_ -> resourcefiltersection.m_215528_(p_215474_.m_135815_()) : null;
            for (String s : list) {
                boolean flag1;
                boolean flag = set.contains(s);
                boolean bl = flag1 = resourcefiltersection != null && resourcefiltersection.m_215523_(s);
                if (!flag && !flag1) continue;
                FallbackResourceManager fallbackresourcemanager = map.computeIfAbsent(s, s1 -> new FallbackResourceManager(PackType.CLIENT_RESOURCES, s1));
                if (flag && flag1) {
                    fallbackresourcemanager.m_215382_(packresources, predicate);
                    continue;
                }
                if (flag) {
                    fallbackresourcemanager.m_215377_(packresources);
                    continue;
                }
                fallbackresourcemanager.m_215399_(packresources.m_5542_(), predicate);
            }
        }
        this.namespacedManagers = map;
    }

    @Nullable
    private ResourceFilterSection getPackFilterSection(PackResources p_215468_) {
        try {
            return (ResourceFilterSection)p_215468_.m_5550_((MetadataSectionSerializer)ResourceFilterSection.f_244163_);
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to get filter section from pack {}", (Object)p_215468_.m_5542_());
            return null;
        }
    }

    public Set<String> m_7187_() {
        return this.namespacedManagers.keySet();
    }

    public Optional<Resource> m_213713_(ResourceLocation p_215482_) {
        ResourceManager resourcemanager = (ResourceManager)this.namespacedManagers.get(p_215482_.m_135827_());
        return resourcemanager != null ? resourcemanager.m_213713_(p_215482_) : Optional.empty();
    }

    public List<Resource> m_213829_(ResourceLocation p_215466_) {
        ResourceManager resourcemanager = (ResourceManager)this.namespacedManagers.get(p_215466_.m_135827_());
        return resourcemanager != null ? resourcemanager.m_213829_(p_215466_) : List.of();
    }

    public Map<ResourceLocation, Resource> m_214159_(String p_215476_, Predicate<ResourceLocation> p_215477_) {
        KiwiPackResourceManager.checkTrailingDirectoryPath(p_215476_);
        TreeMap<ResourceLocation, Resource> map = new TreeMap<ResourceLocation, Resource>();
        for (FallbackResourceManager fallbackresourcemanager : this.namespacedManagers.values()) {
            map.putAll(fallbackresourcemanager.m_214159_(p_215476_, p_215477_));
        }
        return map;
    }

    public Map<ResourceLocation, List<Resource>> m_214160_(String p_215479_, Predicate<ResourceLocation> p_215480_) {
        KiwiPackResourceManager.checkTrailingDirectoryPath(p_215479_);
        TreeMap<ResourceLocation, List<Resource>> map = new TreeMap<ResourceLocation, List<Resource>>();
        for (FallbackResourceManager fallbackresourcemanager : this.namespacedManagers.values()) {
            map.putAll(fallbackresourcemanager.m_214160_(p_215479_, p_215480_));
        }
        return map;
    }

    private static void checkTrailingDirectoryPath(String p_249608_) {
        if (p_249608_.endsWith("/")) {
            throw new IllegalArgumentException("Trailing slash in path " + p_249608_);
        }
    }

    public Stream<PackResources> m_7536_() {
        return this.packs.stream();
    }

    public void close() {
        this.packs.forEach(PackResources::close);
    }
}

