/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.builder.BlockSpread;
import snownee.kiwi.customization.builder.BuilderRule;

public record ReplaceBuilderRule(Map<BlockFamily, Object> families, BlockSpread spread) implements BuilderRule
{
    @Override
    public Stream<Block> relatedBlocks() {
        return this.families.keySet().stream().flatMap(BlockFamily::blocks);
    }

    @Override
    public boolean matches(Player player, ItemStack itemStack, BlockState blockState) {
        if (itemStack.m_150930_(blockState.m_60734_().m_5456_())) {
            return false;
        }
        return this.relatedBlocks().anyMatch(block -> itemStack.m_150930_(block.m_5456_()));
    }

    @Override
    public void apply(UseOnContext context, List<BlockPos> positions) {
        ItemStack itemStack = context.m_43722_().m_41777_();
        Item item = itemStack.m_41720_().m_5456_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem item2 = (BlockItem)item;
        BlockPlaceContext placeContext = new BlockPlaceContext(context);
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        boolean success = false;
        for (BlockPos pos : positions) {
            BlockState oldBlock = level.m_8055_(pos);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 4);
            placeContext = BlockPlaceContext.m_43644_((BlockPlaceContext)placeContext, (BlockPos)pos, (Direction)context.m_43719_());
            if (item2.m_40576_(placeContext) == InteractionResult.FAIL) {
                level.m_7731_(pos, oldBlock, 4);
            } else {
                success = true;
            }
            if (player == null) continue;
            player.m_21008_(context.m_43724_(), itemStack);
        }
        if (success && player != null) {
            BlockState blockState = item2.m_40614_().m_49966_();
            SoundType soundType = blockState.m_60827_();
            level.m_5594_(null, player.m_20183_(), soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        }
    }

    @Override
    public List<BlockPos> searchPositions(UseOnContext context) {
        List<BlockPos> list = List.of();
        try {
            list = this.spread.collect(context, (Predicate<Block>)Predicates.alwaysTrue());
        }
        catch (Exception e) {
            Kiwi.LOGGER.error("Failed to collect positions", (Throwable)e);
        }
        return list;
    }
}

