/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class NBTHelper {
    @Nullable
    private final ItemStack stack;
    @Nullable
    private CompoundTag tag;

    private NBTHelper(@Nullable CompoundTag tag, @Nullable ItemStack stack) {
        this.stack = stack;
        this.tag = tag;
    }

    @Nullable
    public CompoundTag getTag(String key) {
        return this.getTag(key, false);
    }

    public CompoundTag getTag(String key, boolean createIfNull) {
        return this.getTagInternal(key, createIfNull, false);
    }

    private CompoundTag getTagInternal(String key, boolean createIfNull, boolean ignoreLastNode) {
        if (this.tag == null) {
            if (createIfNull) {
                this.tag = new CompoundTag();
                if (this.stack != null) {
                    this.stack.m_41751_(this.tag);
                }
            } else {
                return null;
            }
        }
        if (key.isEmpty()) {
            return this.tag;
        }
        CompoundTag subTag = this.tag;
        String[] parts = key.split("\\.");
        int length = parts.length;
        if (ignoreLastNode) {
            --length;
        }
        for (int i = 0; i < length; ++i) {
            if (!subTag.m_128425_(parts[i], 10)) {
                if (createIfNull) {
                    subTag.m_128365_(parts[i], (Tag)new CompoundTag());
                } else {
                    return null;
                }
            }
            subTag = (CompoundTag)subTag.m_128423_(parts[i]);
        }
        return subTag;
    }

    private CompoundTag getTagInternal(String key) {
        return this.getTagInternal(key, true, true);
    }

    private String getLastNode(String key) {
        int index = key.lastIndexOf(".");
        if (index < 0) {
            return key;
        }
        return key.substring(index + 1);
    }

    public NBTHelper setTag(String key, Tag value) {
        this.getTagInternal(key).m_128365_(this.getLastNode(key), value);
        return this;
    }

    public NBTHelper setInt(String key, int value) {
        this.getTagInternal(key).m_128405_(this.getLastNode(key), value);
        return this;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 3)) {
            return subTag.m_128451_(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setLong(String key, long value) {
        this.getTagInternal(key).m_128356_(this.getLastNode(key), value);
        return this;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 4)) {
            return subTag.m_128454_(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setShort(String key, short value) {
        this.getTagInternal(key).m_128376_(this.getLastNode(key), value);
        return this;
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 2)) {
            return subTag.m_128448_(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setDouble(String key, double value) {
        this.getTagInternal(key).m_128347_(this.getLastNode(key), value);
        return this;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 6)) {
            return subTag.m_128459_(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setFloat(String key, float value) {
        this.getTagInternal(key).m_128350_(this.getLastNode(key), value);
        return this;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 5)) {
            return subTag.m_128457_(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setByte(String key, byte value) {
        this.getTagInternal(key).m_128350_(this.getLastNode(key), (float)value);
        return this;
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String key, byte defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 1)) {
            return subTag.m_128445_(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setBoolean(String key, boolean value) {
        this.getTagInternal(key).m_128379_(this.getLastNode(key), value);
        return this;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 1)) {
            return subTag.m_128471_(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setPos(String key, BlockPos value) {
        this.getTagInternal(key).m_128365_(this.getLastNode(key), (Tag)NbtUtils.m_129224_((BlockPos)value));
        return this;
    }

    @Nullable
    public BlockPos getPos(String key) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 10)) {
            return NbtUtils.m_129239_((CompoundTag)this.getTag(actualKey));
        }
        return null;
    }

    public NBTHelper setBlockState(String key, BlockState value) {
        return this.setTag(key, (Tag)NbtUtils.m_129202_((BlockState)value));
    }

    public BlockState getBlockState(String key) {
        CompoundTag subTag = this.getTagInternal(key, false, false);
        if (subTag != null) {
            return NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)subTag);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public NBTHelper setGameProfile(String key, GameProfile value) {
        NbtUtils.m_129230_((CompoundTag)this.getTag(key, true), (GameProfile)value);
        return this;
    }

    @Nullable
    public GameProfile getGameProfile(String key) {
        CompoundTag subTag = this.getTagInternal(key, false, false);
        if (subTag != null) {
            return NbtUtils.m_129228_((CompoundTag)subTag);
        }
        return null;
    }

    public NBTHelper setString(String key, String value) {
        this.getTagInternal(key).m_128359_(this.getLastNode(key), value);
        return this;
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 8)) {
            return subTag.m_128461_(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setIntArray(String key, int[] value) {
        this.getTagInternal(key).m_128385_(this.getLastNode(key), value);
        return this;
    }

    public int[] getIntArray(String key) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 11)) {
            return subTag.m_128465_(actualKey);
        }
        return new int[0];
    }

    public NBTHelper setByteArray(String key, byte[] value) {
        this.getTagInternal(key).m_128382_(this.getLastNode(key), value);
        return this;
    }

    public byte[] getByteArray(String key) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 7)) {
            return subTag.m_128463_(actualKey);
        }
        return new byte[0];
    }

    public NBTHelper setUUID(String key, UUID value) {
        this.getTagInternal(key).m_128362_(this.getLastNode(key), value);
        return this;
    }

    @Nullable
    public UUID getUUID(String key) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (!(subTag == null || subTag.m_128425_((actualKey = this.getLastNode(key)) + "Most", 4) && subTag.m_128425_(actualKey + "Least", 4))) {
            return subTag.m_128342_(actualKey);
        }
        return null;
    }

    @Nullable
    public ListTag getTagList(String key, int type) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.m_128425_(actualKey = this.getLastNode(key), 9)) {
            return subTag.m_128437_(actualKey, type);
        }
        return null;
    }

    public boolean hasTag(String key, int type) {
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null) {
            if (key.isEmpty()) {
                return true;
            }
            String actualKey = this.getLastNode(key);
            return subTag.m_128425_(actualKey, type);
        }
        return false;
    }

    public Set<String> keySet(String key) {
        return this.hasTag(key, 10) ? this.getTag(key).m_128431_() : Collections.EMPTY_SET;
    }

    public NBTHelper remove(String key) {
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null) {
            String actualKey = this.getLastNode(key);
            subTag.m_128473_(actualKey);
        }
        return this;
    }

    @Nullable
    public CompoundTag get() {
        return this.tag;
    }

    public ItemStack getItem() {
        return this.stack == null ? ItemStack.f_41583_ : this.stack;
    }

    public static NBTHelper of(ItemStack stack) {
        return new NBTHelper(stack.m_41783_(), stack);
    }

    public static NBTHelper of(CompoundTag tag) {
        return new NBTHelper(tag, null);
    }

    public static NBTHelper create() {
        return NBTHelper.of(new CompoundTag());
    }
}

