/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.RectDebugger;
import mezz.jei.core.util.LimitedLogger;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LimitedLogger missingBackgroundLogger = new LimitedLogger(LOGGER, Duration.ofHours(1L));
    private final IngredientListOverlay ingredientListOverlay;
    private final IScreenHelper screenHelper;
    private final BookmarkOverlay bookmarkOverlay;
    private boolean drawnOnBackground = false;

    public GuiEventHandler(IScreenHelper screenHelper, BookmarkOverlay bookmarkOverlay, IngredientListOverlay ingredientListOverlay) {
        this.screenHelper = screenHelper;
        this.bookmarkOverlay = bookmarkOverlay;
        this.ingredientListOverlay = ingredientListOverlay;
    }

    public void onGuiInit(Screen screen) {
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.getScreenPropertiesUpdater().updateScreen(screen).updateExclusionAreas(guiExclusionAreas).update();
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateScreen(screen).updateExclusionAreas(guiExclusionAreas).update();
    }

    public void onGuiOpen(Screen screen) {
        this.ingredientListOverlay.getScreenPropertiesUpdater().updateScreen(screen).update();
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateScreen(screen).update();
    }

    public void onDrawBackgroundPost(Screen screen, GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.m_91087_();
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.getScreenPropertiesUpdater().updateScreen(screen).updateExclusionAreas(guiExclusionAreas).update();
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateScreen(screen).updateExclusionAreas(guiExclusionAreas).update();
        this.drawnOnBackground = true;
        double mouseX = MouseUtil.getX();
        double mouseY = MouseUtil.getY();
        this.ingredientListOverlay.drawScreen(minecraft, guiGraphics, (int)mouseX, (int)mouseY, minecraft.m_91296_());
        this.bookmarkOverlay.drawScreen(minecraft, guiGraphics, (int)mouseX, (int)mouseY, minecraft.m_91296_());
    }

    public void onDrawForeground(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
        poseStack.m_252880_((float)(-screenHelper.getGuiLeft(screen)), (float)(-screenHelper.getGuiTop(screen)), 0.0f);
        this.bookmarkOverlay.drawOnForeground(guiGraphics, mouseX, mouseY);
        this.ingredientListOverlay.drawOnForeground(guiGraphics, mouseX, mouseY);
        poseStack.m_85849_();
    }

    public void onDrawScreenPost(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.getScreenPropertiesUpdater().updateScreen(screen).updateExclusionAreas(guiExclusionAreas).update();
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateScreen(screen).updateExclusionAreas(guiExclusionAreas).update();
        if (!this.drawnOnBackground) {
            if (screen instanceof AbstractContainerScreen) {
                String guiName = screen.getClass().getName();
                missingBackgroundLogger.log(Level.WARN, guiName, "GUI did not draw the dark background layer behind itself, this may result in display issues: {}", guiName);
            }
            this.ingredientListOverlay.drawScreen(minecraft, guiGraphics, mouseX, mouseY, minecraft.m_91296_());
            this.bookmarkOverlay.drawScreen(minecraft, guiGraphics, mouseX, mouseY, minecraft.m_91296_());
        }
        this.drawnOnBackground = false;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen;
            IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
            int guiLeft = screenHelper.getGuiLeft(guiContainer);
            int guiTop = screenHelper.getGuiTop(guiContainer);
            this.screenHelper.getGuiClickableArea(guiContainer, mouseX - guiLeft, mouseY - guiTop).filter(IGuiClickableArea::isTooltipEnabled).findFirst().ifPresent(area -> {
                JeiTooltip tooltip = new JeiTooltip();
                area.getTooltip(tooltip);
                if (tooltip.isEmpty()) {
                    tooltip.add((FormattedText)Component.m_237115_((String)"jei.tooltip.show.recipes"));
                }
                tooltip.draw(guiGraphics, mouseX, mouseY);
            });
        }
        this.ingredientListOverlay.drawTooltips(minecraft, guiGraphics, mouseX, mouseY);
        this.bookmarkOverlay.drawTooltips(minecraft, guiGraphics, mouseX, mouseY);
        if (DebugConfig.isDebugGuisEnabled()) {
            this.drawDebugInfoForScreen(screen, guiGraphics);
        }
    }

    public void onClientTick() {
        this.ingredientListOverlay.handleTick();
    }

    public boolean renderCompactPotionIndicators() {
        return this.ingredientListOverlay.isListDisplayed();
    }

    private void drawDebugInfoForScreen(Screen screen, GuiGraphics guiGraphics) {
        RectDebugger.INSTANCE.draw(guiGraphics);
        this.screenHelper.getGuiProperties(screen).ifPresent(guiProperties -> {
            Set guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).collect(Collectors.toUnmodifiableSet());
            RenderSystem.disableDepthTest();
            for (Rect2i area : guiExclusionAreas) {
                guiGraphics.m_285944_(RenderType.m_285907_(), area.m_110085_(), area.m_110086_(), area.m_110085_() + area.m_110090_(), area.m_110086_() + area.m_110091_(), 0x44FF0000);
            }
            guiGraphics.m_285944_(RenderType.m_285907_(), guiProperties.getGuiLeft(), guiProperties.getGuiTop(), guiProperties.getGuiLeft() + guiProperties.getGuiXSize(), guiProperties.getGuiTop() + guiProperties.getGuiYSize(), 0x22CCCC00);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        });
    }
}

