/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PickaxeTrim(@NotNull TrimType type) {
    public static final String NBT_KEY = "pickaxetrims_trim_type";
    private static final Component UPGRADE_TEXT = Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("smithing_template.upgrade"))).m_130940_(ChatFormatting.GRAY);

    @NotNull
    public TrimType trimType() {
        return this.type();
    }

    @Nullable
    public static PickaxeTrim get(@NotNull ItemStack stack) {
        TrimType trimType;
        if (stack.m_41782_() && (trimType = TrimType.BY_NAME.get(stack.m_41783_().m_128461_(NBT_KEY))) != null) {
            return new PickaxeTrim(trimType);
        }
        return null;
    }

    @NotNull
    public static ItemStack set(@NotNull ItemStack stack, @NotNull PickaxeTrim trim) {
        return PickaxeTrim.set(stack, trim.trimType());
    }

    @NotNull
    public static ItemStack set(@NotNull ItemStack stack, @NotNull TrimType trimType) {
        stack.m_41784_().m_128359_(NBT_KEY, trimType.toString());
        return stack;
    }

    @Nullable
    public static PickaxeType getPickaxeType(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return PickaxeType.from(stack.m_41720_());
    }

    @Nullable
    public static TrimType getTrimType(@Nullable ItemStack stack) {
        PickaxeTrim trim;
        if (stack != null && (trim = PickaxeTrim.get(stack)) != null) {
            return trim.trimType();
        }
        return null;
    }

    public static boolean isOfTrimType(@Nullable ItemStack stack, @NotNull TrimType trimType) {
        return PickaxeTrim.getTrimType(stack) == trimType;
    }

    public static void appendTooltip(ItemStack stack, List<Component> tooltip) {
        TrimType trimType = PickaxeTrim.getTrimType(stack);
        if (trimType != null) {
            tooltip.add(UPGRADE_TEXT);
            tooltip.add((Component)CommonComponents.m_264333_().m_7220_(trimType.getMaterialText()));
            tooltip.add((Component)CommonComponents.m_264333_().m_7220_(trimType.getDescriptionText()));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TrimType {
        CRYING_OBSIDIAN{

            @NotNull
            public String toString() {
                return "crying_obsidian";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.f_42754_;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.DARK_PURPLE;
            }
        }
        ,
        LAPIS_LAZULI{

            @NotNull
            public String toString() {
                return "lapis_lazuli";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.f_42534_;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.BLUE;
            }
        }
        ,
        EMERALD{

            @NotNull
            public String toString() {
                return "emerald";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.f_42616_;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.GREEN;
            }
        }
        ,
        QUARTZ{

            @NotNull
            public String toString() {
                return "quartz";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.f_42692_;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.WHITE;
            }
        }
        ,
        REDSTONE{

            @NotNull
            public String toString() {
                return "redstone";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.f_42451_;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.RED;
            }
        }
        ,
        COPPER{

            @NotNull
            public String toString() {
                return "copper";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.f_151052_;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.GOLD;
            }
        };

        @NotNull
        public static final List<TrimType> VALUES;
        public static final int COUNT;
        @NotNull
        private static final Map<String, TrimType> BY_NAME;

        @Nullable
        public static TrimType parse(@Nullable String name) {
            return BY_NAME.get(name);
        }

        @Nullable
        public static TrimType from(@NotNull Item item) {
            if (item == Items.f_42754_) {
                return CRYING_OBSIDIAN;
            }
            if (item == Items.f_42534_) {
                return LAPIS_LAZULI;
            }
            if (item == Items.f_42616_) {
                return EMERALD;
            }
            if (item == Items.f_42692_) {
                return QUARTZ;
            }
            if (item == Items.f_42451_) {
                return REDSTONE;
            }
            if (item == Items.f_151052_) {
                return COPPER;
            }
            return null;
        }

        @NotNull
        public abstract Item getItem();

        @NotNull
        public abstract ChatFormatting getColor();

        @NotNull
        public Component getMaterialText() {
            return Component.m_237115_((String)("pickaxetrims.material." + this)).m_130940_(this.getColor());
        }

        @NotNull
        public Component getDescriptionText() {
            return Component.m_237115_((String)("pickaxetrims.description." + this)).m_130940_(this.getColor());
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])TrimType.values());
            COUNT = VALUES.size();
            BY_NAME = (Map)Util.m_137469_(new HashMap(), map -> {
                for (TrimType type : VALUES) {
                    map.put(type.toString(), type);
                }
            });
        }
    }

    public static enum PickaxeType {
        NETHERITE,
        DIAMOND,
        GOLD,
        IRON;

        @NotNull
        public static final List<PickaxeType> VALUES;
        public static final int COUNT;

        @Nullable
        private static PickaxeType from(@NotNull Item item) {
            if (item == Items.f_42395_) {
                return NETHERITE;
            }
            if (item == Items.f_42390_) {
                return DIAMOND;
            }
            if (item == Items.f_42432_) {
                return GOLD;
            }
            if (item == Items.f_42385_) {
                return IRON;
            }
            return null;
        }

        @NotNull
        public Item getItem() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NETHERITE -> Items.f_42395_;
                case DIAMOND -> Items.f_42390_;
                case GOLD -> Items.f_42432_;
                case IRON -> Items.f_42385_;
            };
        }

        @NotNull
        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NETHERITE -> "netherite_pickaxe";
                case DIAMOND -> "diamond_pickaxe";
                case GOLD -> "gold_pickaxe";
                case IRON -> "iron_pickaxe";
            };
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])PickaxeType.values());
            COUNT = VALUES.size();
        }
    }
}

