/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology.jei;

import cy.jdkdigital.jearchaeology.jei.JeiPlugin;
import cy.jdkdigital.jearchaeology.recipe.SniffRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SniffRecipeCategory
implements IRecipeCategory<SniffRecipe> {
    private static List<SniffRecipe> cachedRecipes = new ArrayList<SniffRecipe>();
    private final IDrawable background;
    private final IDrawable icon;

    public SniffRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(126, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_276468_));
    }

    public static List<SniffRecipe> getAllRecipes(ServerLevel level) {
        if (level != null && cachedRecipes.isEmpty()) {
            Sniffer sniffer = (Sniffer)EntityType.f_271264_.m_20615_((Level)level);
            LootParams lootparams = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)new Vec3(0.0, 0.0, 0.0)).m_287286_(LootContextParams.f_81455_, (Object)sniffer).m_287235_(LootContextParamSets.f_81416_);
            HashMap items = new HashMap();
            LootTable table = level.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_283841_);
            for (int i = 0; i < 200; ++i) {
                table.m_287195_(lootparams).forEach(itemStack -> {
                    if (!items.containsKey(itemStack.m_41720_())) {
                        items.put(itemStack.m_41720_(), itemStack);
                    }
                });
            }
            SniffRecipeCategory.setRecipes(List.of(new SniffRecipe(new ResourceLocation("jearchaeology", "sniffing"), Ingredient.m_43927_((ItemStack[])items.values().toArray(new ItemStack[0])), 1.0)));
        }
        return cachedRecipes;
    }

    public static void setRecipes(List<SniffRecipe> data) {
        cachedRecipes = data;
    }

    @NotNull
    public RecipeType<SniffRecipe> getRecipeType() {
        return JeiPlugin.SNIFF_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"jearchaeology.recipe.sniff");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SniffRecipe recipe, @NotNull IFocusGroup iFocusGroup) {
        AtomicInteger i = new AtomicInteger();
        Arrays.stream(recipe.item.m_43908_()).forEach(itemStack -> {
            int row = (int)Math.floor((float)i.get() / 7.0f);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, (i.get() - row * 7) * 18, row * 18).addItemStack(itemStack)).setSlotName("thing" + i);
            i.set(i.get() + 1);
        });
    }
}

