/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.natives.util;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.util.BufferPreference;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

public class MoreByteBufUtils {
    private MoreByteBufUtils() {
        throw new AssertionError();
    }

    public static ByteBuf ensureCompatible(ByteBufAllocator alloc, Native nativeStuff, ByteBuf buf) {
        if (MoreByteBufUtils.isCompatible(nativeStuff, buf)) {
            return buf.retain();
        }
        ByteBuf newBuf = MoreByteBufUtils.preferredBuffer(alloc, nativeStuff, buf.readableBytes());
        newBuf.writeBytes(buf);
        return newBuf;
    }

    private static boolean isCompatible(Native nativeStuff, ByteBuf buf) {
        BufferPreference preferred = nativeStuff.preferredBufferType();
        switch (preferred) {
            case DIRECT_PREFERRED: 
            case HEAP_PREFERRED: {
                return true;
            }
            case DIRECT_REQUIRED: {
                return buf.hasMemoryAddress();
            }
            case HEAP_REQUIRED: {
                return buf.hasArray();
            }
        }
        throw new AssertionError((Object)"Preferred buffer type unknown");
    }

    public static ByteBuf preferredBuffer(ByteBufAllocator alloc, Native nativeStuff, int initialCapacity) {
        switch (nativeStuff.preferredBufferType()) {
            case HEAP_PREFERRED: 
            case HEAP_REQUIRED: {
                return alloc.heapBuffer(initialCapacity);
            }
            case DIRECT_PREFERRED: 
            case DIRECT_REQUIRED: {
                return alloc.directBuffer(initialCapacity);
            }
        }
        throw new AssertionError((Object)"Preferred buffer type unknown");
    }
}

