/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.adorable_eggs.mixin;

import com.cerbon.adorable_eggs.AdorableEggs;
import com.cerbon.adorable_eggs.block.custom.EggBlock;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpawnEggItem.class})
public class SpawnEggItemMixin
extends Item {
    public SpawnEggItemMixin(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (AdorableEggs.config.isPlaceEggsEnabled) {
            Minecraft client = Minecraft.m_91087_();
            LocalPlayer player = client.f_91074_;
            if (player == null) {
                return;
            }
            if (player.m_7500_()) {
                tooltipComponents.add((Component)Component.m_237115_((String)"item.minecraft.spawn_egg.creative_tooltip"));
            } else {
                tooltipComponents.add((Component)Component.m_237115_((String)"item.minecraft.spawn_egg.survival_tooltip"));
            }
        }
    }

    @Inject(method={"useOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;")}, cancellable=true)
    private void useOn(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Player player = context.m_43723_();
        if (player == null || !AdorableEggs.config.isPlaceEggsEnabled || this.getBlock() == null) {
            return;
        }
        if (player.m_7500_() && player.m_6144_() || !player.m_7500_()) {
            cir.setReturnValue((Object)this.place(new BlockPlaceContext(context)));
        }
    }

    @Inject(method={"getColor"}, at={@At(value="RETURN")}, cancellable=true)
    private void getColor(int tintIndex, CallbackInfoReturnable<Integer> cir) {
        if (EggBlock.SPAWN_EGG_TO_BLOCK_EGG.get((SpawnEggItem)this) != null) {
            cir.setReturnValue((Object)0xFFFFFF);
        }
    }

    @Unique
    public InteractionResult place(BlockPlaceContext context) {
        if (!this.getBlock().m_245993_(context.m_43725_().m_246046_())) {
            return InteractionResult.FAIL;
        }
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockPlaceContext = this.updatePlacementContext(context);
        if (blockPlaceContext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = this.getPlacementState(blockPlaceContext);
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockPlaceContext, blockState)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        Player player = blockPlaceContext.m_43723_();
        ItemStack itemStack = blockPlaceContext.m_43722_();
        BlockState blockState2 = level.m_8055_(blockPos);
        if (blockState2.m_60713_(blockState.m_60734_())) {
            blockState2 = this.updateBlockStateFromTag(blockPos, level, itemStack, blockState2);
            this.updateCustomBlockEntityTag(blockPos, level, player, itemStack, blockState2);
            blockState2.m_60734_().m_6402_(level, blockPos, blockState2, (LivingEntity)player, itemStack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockPos, itemStack);
            }
        }
        SoundType soundType = blockState2.m_60827_();
        level.m_5594_(null, blockPos, this.getPlaceSound(blockState2), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        level.m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState2));
        if (player == null || !player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Unique
    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    @Unique
    private BlockState updateBlockStateFromTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        BlockState blockState = state;
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null) {
            CompoundTag compoundTag2 = compoundTag.m_128469_("BlockStateTag");
            StateDefinition stateDefinition = blockState.m_60734_().m_49965_();
            for (String string : compoundTag2.m_128431_()) {
                Property property = stateDefinition.m_61081_(string);
                if (property == null) continue;
                String string2 = compoundTag2.m_128423_(string).m_7916_();
                blockState = SpawnEggItemMixin.updateState(blockState, property, string2);
            }
        }
        if (blockState != state) {
            level.m_7731_(pos, blockState, 2);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> property, String valueIdentifier) {
        return property.m_6215_(valueIdentifier).map(comparable -> (BlockState)state.m_61124_(property, comparable)).orElse(state);
    }

    @Unique
    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        return BlockItem.m_40582_((Level)level, (Player)player, (BlockPos)pos, (ItemStack)stack);
    }

    @Unique
    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState blockState = this.getBlock().m_5573_(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    @Unique
    protected Block getBlock() {
        return (Block)EggBlock.SPAWN_EGG_TO_BLOCK_EGG.get((Object)this);
    }

    @Unique
    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.m_43723_();
        CollisionContext collisionContext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return (!this.mustSurvive() || state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) && context.m_43725_().m_45752_(state, context.m_8083_(), collisionContext);
    }

    @Unique
    protected boolean mustSurvive() {
        return true;
    }

    @Unique
    protected SoundEvent getPlaceSound(BlockState state) {
        return state.m_60827_().m_56777_();
    }
}

