/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.helper.ChannelMode;
import nx.pingwheel.common.helper.LanguageUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class ServerCommandBuilder {
    private ServerCommandBuilder() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> build(TriConsumer<CommandContext<CommandSourceStack>, Boolean, MutableComponent> responseHandler) {
        LanguageUtils.LanguageWrapper langDefaultChannel = LanguageUtils.command("default_channel");
        LanguageUtils.LanguageWrapper langPlayerTracking = LanguageUtils.command("player_tracking");
        LanguageUtils.LanguageWrapper langRegenTime = LanguageUtils.command("regen_time");
        LanguageUtils.LanguageWrapper langRateLimit = LanguageUtils.command("rate_limit");
        List<ChannelMode> validModes = List.of(ChannelMode.values());
        List<String> validModeNames = validModes.stream().map(ChannelMode::toString).toList();
        LiteralArgumentBuilder cmdDefaultChannel = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"default_channel").executes(context -> {
            ChannelMode currentChannelMode = Global.ServerConfigHandler.getConfig().getDefaultChannelMode();
            responseHandler.accept((Object)context, (Object)true, (Object)langDefaultChannel.path("get.response").get(langDefaultChannel.path("value").path(currentChannelMode.toString()).get(new Object[0]).m_130940_(ChatFormatting.YELLOW)));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"mode_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CompletableFuture.supplyAsync(() -> {
            for (String mode : validModeNames) {
                builder.suggest(mode);
            }
            return builder.build();
        })).executes(context -> {
            String newModeStr = (String)context.getArgument("mode_name", String.class);
            ChannelMode newMode = validModes.stream().filter(e -> e.name().equalsIgnoreCase(newModeStr)).findFirst().orElse(null);
            if (newMode == null) {
                responseHandler.accept((Object)context, (Object)false, (Object)langDefaultChannel.path("set.reject").get(String.join((CharSequence)" | ", validModeNames)));
                return 0;
            }
            Global.ServerConfigHandler.getConfig().setDefaultChannelMode(newMode);
            Global.ServerConfigHandler.save();
            responseHandler.accept((Object)context, (Object)true, (Object)langDefaultChannel.path("set.response").get(langDefaultChannel.path("value").path(newMode.toString()).get(new Object[0]).m_130940_(ChatFormatting.YELLOW)));
            return 1;
        }));
        LiteralArgumentBuilder cmdPlayerTracking = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"player_tracking").executes(context -> {
            boolean isPlayerTrackingEnabled = Global.ServerConfigHandler.getConfig().isPlayerTrackingEnabled();
            responseHandler.accept((Object)context, (Object)true, (Object)langPlayerTracking.path("get.response").get(LanguageUtils.from(isPlayerTrackingEnabled).m_130940_(ChatFormatting.YELLOW)));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            Boolean enablePlayerTracking = (Boolean)context.getArgument("state", Boolean.class);
            Global.ServerConfigHandler.getConfig().setPlayerTrackingEnabled(enablePlayerTracking);
            Global.ServerConfigHandler.save();
            responseHandler.accept((Object)context, (Object)true, (Object)langPlayerTracking.path("set.response").get(LanguageUtils.from(enablePlayerTracking).m_130940_(ChatFormatting.YELLOW)));
            return 1;
        }));
        LiteralArgumentBuilder cmdRegenTime = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"regen_time").executes(context -> {
            int regenTime = Global.ServerConfigHandler.getConfig().getMsToRegenerate();
            responseHandler.accept((Object)context, (Object)true, (Object)langRegenTime.path("get.response").get(LanguageUtils.from(regenTime).m_130940_(ChatFormatting.YELLOW)));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Integer regenTime = (Integer)context.getArgument("time", Integer.class);
            Global.ServerConfigHandler.getConfig().setMsToRegenerate(regenTime);
            Global.ServerConfigHandler.save();
            responseHandler.accept((Object)context, (Object)true, (Object)langRegenTime.path("set.response").get(LanguageUtils.from(regenTime).m_130940_(ChatFormatting.YELLOW)));
            return 1;
        }));
        LiteralArgumentBuilder cmdRateLimit = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"rate_limit").executes(context -> {
            int rateLimit = Global.ServerConfigHandler.getConfig().getRateLimit();
            responseHandler.accept((Object)context, (Object)true, (Object)langRateLimit.path("get.response").get(LanguageUtils.from(rateLimit).m_130940_(ChatFormatting.YELLOW)));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Integer rateLimit = (Integer)context.getArgument("limit", Integer.class);
            Global.ServerConfigHandler.getConfig().setRateLimit(rateLimit);
            Global.ServerConfigHandler.save();
            responseHandler.accept((Object)context, (Object)true, (Object)langRateLimit.path("set.response").get(LanguageUtils.from(rateLimit).m_130940_(ChatFormatting.YELLOW)));
            return 1;
        }));
        Command helpCallback = context -> {
            responseHandler.accept((Object)context, (Object)true, (Object)LanguageUtils.join(Component.m_237119_(), Component.m_237113_((String)"/pingwheel:server default_channel"), LanguageUtils.wrapped(langDefaultChannel.path("get.description").get(new Object[0])).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)"/pingwheel:server default_channel <mode_name>"), LanguageUtils.wrapped(langDefaultChannel.path("set.description").get(new Object[0])).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)"/pingwheel:server player_tracking"), LanguageUtils.wrapped(langPlayerTracking.path("get.description").get(new Object[0])).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)"/pingwheel:server player_tracking true|false"), LanguageUtils.wrapped(langPlayerTracking.path("set.description").get(new Object[0])).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)"/pingwheel:server regen_time"), LanguageUtils.wrapped(langRegenTime.path("get.description").get(new Object[0])).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)"/pingwheel:server regen_time <milliseconds>"), LanguageUtils.wrapped(langRegenTime.path("set.description").get(new Object[0])).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)"/pingwheel:server rate_limit"), LanguageUtils.wrapped(langRateLimit.path("get.description").get(new Object[0])).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)"/pingwheel:server rate_limit <limit>"), LanguageUtils.wrapped(langRateLimit.path("set.description").get(new Object[0])).m_130940_(ChatFormatting.GRAY)));
            return 1;
        };
        LiteralArgumentBuilder cmdHelp = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").executes(helpCallback);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"pingwheel:server").requires(source -> source.m_6761_(2))).executes(helpCallback)).then((ArgumentBuilder)cmdHelp)).then((ArgumentBuilder)cmdDefaultChannel)).then((ArgumentBuilder)cmdPlayerTracking)).then((ArgumentBuilder)cmdRegenTime)).then((ArgumentBuilder)cmdRateLimit);
    }
}

