/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SometimesVisibleBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class FloorTrapBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity {
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.BooleanOption disappearInstantlyInChains = new Option.BooleanOption("disappearInstantlyInChains", true);
    private Option.IntOption disappearDelay = new Option.IntOption("disappearDelay", 5, 0, 200, 1);
    private Option.IntOption reappearDelay = new Option.IntOption("reappearDelay", 20, 5, 200, 1);
    private Option.TargetingModeOption targetingMode = new Option.TargetingModeOption(TargetingMode.PLAYERS);
    private boolean shouldDisappear = false;
    private boolean shouldReappear = false;
    private int ticksUntilDisappearing = -1;
    private int ticksUntilReappearing = -1;

    public FloorTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.FLOOR_TRAP_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.shouldReappear && this.shouldDisappear) {
            if (this.ticksUntilDisappearing-- <= 0) {
                this.disappear();
            }
            return;
        }
        TargetingMode mode = (TargetingMode)((Object)this.targetingMode.get());
        this.shouldDisappear = level.m_6443_(LivingEntity.class, new AABB(pos.m_7494_()).m_165893_((double)pos.m_123342_() + 1.1666), e -> {
            OwnableEntity ownableEntity;
            return !(!e.m_142065_() || e instanceof OwnableEntity && this.allowsOwnableEntity(ownableEntity = (OwnableEntity)e) || this.isAllowed((Entity)e) || this.isOwnedBy((Entity)e) && this.ignoresOwner());
        }).stream().anyMatch(entity -> mode.allowsPlayers() && entity instanceof Player || mode.allowsMobs());
        if (this.shouldReappear && this.ticksUntilReappearing-- <= 0 && !this.shouldDisappear) {
            this.reappear();
        }
        this.scheduleDisappear(false);
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, FloorTrapBlockEntity blockEntity) {
        level.m_6493_((ParticleOptions)SCContent.FLOOR_TRAP_CLOUD.get(), false, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
    }

    public void scheduleDisappear(boolean force) {
        this.scheduleDisappear((Integer)this.disappearDelay.get(), force);
    }

    public void scheduleDisappear(int delay, boolean force) {
        if (force) {
            this.shouldDisappear = true;
        }
        if (this.shouldDisappear) {
            this.ticksUntilDisappearing = delay;
        }
    }

    public void disappear() {
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SometimesVisibleBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)));
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11893_, SoundSource.BLOCKS, 1.0f, 2.0f);
        this.shouldDisappear = false;
        this.scheduleReappear();
    }

    public void scheduleReappear() {
        this.scheduleReappear((Integer)this.reappearDelay.get());
    }

    public void scheduleReappear(int delay) {
        this.shouldReappear = true;
        this.ticksUntilReappearing = delay;
    }

    public void reappear() {
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SometimesVisibleBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)));
        this.shouldReappear = false;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("should_disappear", this.shouldDisappear);
        tag.m_128379_("should_reappear", this.shouldReappear);
        tag.m_128405_("ticks_until_disappearing", this.ticksUntilDisappearing);
        tag.m_128405_("ticks_until_reappearing", this.ticksUntilReappearing);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.shouldDisappear = tag.m_128471_("should_disappear");
        this.shouldReappear = tag.m_128471_("should_reappear");
        this.ticksUntilDisappearing = tag.m_128451_("ticks_until_disappearing");
        this.ticksUntilReappearing = tag.m_128451_("ticks_until_reappearing");
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.ignoreOwner, this.targetingMode, this.disappearInstantlyInChains, this.disappearDelay, this.reappearDelay};
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public boolean shouldDisappearInstantlyInChains() {
        return (Boolean)this.disappearInstantlyInChains.get();
    }
}

