/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.stream.Stream;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.AbstractKeypadFurnaceBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractKeypadFurnaceBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape NORTH_OPEN = Stream.of(Block.m_49796_((double)11.0, (double)1.0, (double)1.0, (double)12.0, (double)2.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)2.0, (double)1.0), Block.m_49796_((double)4.0, (double)1.0, (double)1.0, (double)5.0, (double)2.0, (double)2.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape NORTH_CLOSED = Stream.of(Block.m_49796_((double)4.0, (double)14.0, (double)1.0, (double)5.0, (double)15.0, (double)2.0), Block.m_49796_((double)11.0, (double)14.0, (double)1.0, (double)12.0, (double)15.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)4.0, (double)14.0, (double)0.0, (double)12.0, (double)15.0, (double)1.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape EAST_OPEN = Stream.of(Block.m_49796_((double)14.0, (double)1.0, (double)11.0, (double)15.0, (double)2.0, (double)12.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)1.0, (double)4.0, (double)16.0, (double)2.0, (double)12.0), Block.m_49796_((double)14.0, (double)1.0, (double)4.0, (double)15.0, (double)2.0, (double)5.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape EAST_CLOSED = Stream.of(Block.m_49796_((double)14.0, (double)14.0, (double)4.0, (double)15.0, (double)15.0, (double)5.0), Block.m_49796_((double)14.0, (double)14.0, (double)11.0, (double)15.0, (double)15.0, (double)12.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)14.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SOUTH_OPEN = Stream.of(Block.m_49796_((double)4.0, (double)1.0, (double)14.0, (double)5.0, (double)2.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)4.0, (double)1.0, (double)15.0, (double)12.0, (double)2.0, (double)16.0), Block.m_49796_((double)11.0, (double)1.0, (double)14.0, (double)12.0, (double)2.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SOUTH_CLOSED = Stream.of(Block.m_49796_((double)11.0, (double)14.0, (double)14.0, (double)12.0, (double)15.0, (double)15.0), Block.m_49796_((double)4.0, (double)14.0, (double)14.0, (double)5.0, (double)15.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)4.0, (double)14.0, (double)15.0, (double)12.0, (double)15.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape WEST_OPEN = Stream.of(Block.m_49796_((double)1.0, (double)1.0, (double)4.0, (double)2.0, (double)2.0, (double)5.0), Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)4.0, (double)1.0, (double)2.0, (double)12.0), Block.m_49796_((double)1.0, (double)1.0, (double)11.0, (double)2.0, (double)2.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape WEST_CLOSED = Stream.of(Block.m_49796_((double)1.0, (double)14.0, (double)11.0, (double)2.0, (double)15.0, (double)12.0), Block.m_49796_((double)1.0, (double)14.0, (double)4.0, (double)2.0, (double)15.0, (double)5.0), Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)4.0, (double)1.0, (double)15.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape NORTH_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape WEST_COLLISION = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    protected AbstractKeypadFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity baseContainer = (BaseContainerBlockEntity)blockEntity;
            baseContainer.m_58638_(stack.m_41786_());
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return switch ((Direction)disguisedState.m_61143_((Property)FACING)) {
            case Direction.NORTH -> {
                if (((Boolean)disguisedState.m_61143_((Property)OPEN)).booleanValue()) {
                    yield NORTH_OPEN;
                }
                yield NORTH_CLOSED;
            }
            case Direction.EAST -> {
                if (((Boolean)disguisedState.m_61143_((Property)OPEN)).booleanValue()) {
                    yield EAST_OPEN;
                }
                yield EAST_CLOSED;
            }
            case Direction.SOUTH -> {
                if (((Boolean)disguisedState.m_61143_((Property)OPEN)).booleanValue()) {
                    yield SOUTH_OPEN;
                }
                yield SOUTH_CLOSED;
            }
            case Direction.WEST -> {
                if (((Boolean)disguisedState.m_61143_((Property)OPEN)).booleanValue()) {
                    yield WEST_OPEN;
                }
                yield WEST_CLOSED;
            }
            default -> Shapes.m_83144_();
        };
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return switch ((Direction)disguisedState.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_COLLISION;
            case Direction.EAST -> EAST_COLLISION;
            case Direction.SOUTH -> SOUTH_COLLISION;
            case Direction.WEST -> WEST_COLLISION;
            default -> Shapes.m_83144_();
        };
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
                level.m_46717_(pos, (Block)this);
            }
            if ((blockEntity = level.m_7702_(pos)) instanceof IPasscodeProtected) {
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                SaltData.removeSalt(be.getSaltKey());
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            AbstractKeypadFurnaceBlockEntity be = (AbstractKeypadFurnaceBlockEntity)level.m_7702_(pos);
            if (be.isDisabled()) {
                player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(be, level, pos, player);
                } else if (!player.m_21120_(hand).m_150930_((Item)SCContent.CODEBREAKER.get())) {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(AbstractKeypadFurnaceBlockEntity be, Level level, BlockPos pos, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.m_142346_((Entity)player, GameEvent.f_157803_, pos);
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)be, (BlockPos)pos);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractKeypadFurnaceBlockEntity) {
            AbstractKeypadFurnaceBlockEntity be = (AbstractKeypadFurnaceBlockEntity)blockEntity;
            be.recheckOpen();
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, LIT, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public static class Convertible
    implements IPasscodeConvertible {
        private final Block unprotectedBlock;
        private final Block protectedBlock;

        public Convertible(Block unprotectedBlock, Block protectedBlock) {
            this.unprotectedBlock = unprotectedBlock;
            this.protectedBlock = protectedBlock;
        }

        @Override
        public boolean isUnprotectedBlock(BlockState state) {
            return state.m_60713_(this.unprotectedBlock);
        }

        @Override
        public boolean isProtectedBlock(BlockState state) {
            return state.m_60713_(this.protectedBlock);
        }

        @Override
        public boolean protect(Player player, Level level, BlockPos pos) {
            return this.convert(player, level, pos, this.protectedBlock, true);
        }

        @Override
        public boolean unprotect(Player player, Level level, BlockPos pos) {
            return this.convert(player, level, pos, this.unprotectedBlock, false);
        }

        public boolean convert(Player player, Level level, BlockPos pos, Block convertedBlock, boolean protect) {
            BlockState state = level.m_8055_(pos);
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            boolean lit = (Boolean)state.m_61143_((Property)LIT);
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)level.m_7702_(pos);
            BlockState convertedState = (BlockState)((BlockState)convertedBlock.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit));
            if (protect) {
                convertedState = (BlockState)convertedState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
            } else {
                ((IModuleInventory)furnace).dropAllModules();
            }
            CompoundTag tag = furnace.m_187480_();
            furnace.m_6211_();
            level.m_46597_(pos, convertedState);
            furnace = (AbstractFurnaceBlockEntity)level.m_7702_(pos);
            furnace.m_142466_(tag);
            if (protect && player != null) {
                ((IOwnable)furnace).setOwner(player.m_20148_().toString(), player.m_7755_().getString());
            }
            return true;
        }
    }
}

