/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaserFieldBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty BOUNDTYPE = IntegerProperty.m_61631_((String)"boundtype", (int)1, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_X = Block.m_49796_((double)0.0, (double)6.75, (double)6.75, (double)16.0, (double)9.25, (double)9.25);
    private static final VoxelShape SHAPE_Y = Block.m_49796_((double)6.75, (double)0.0, (double)6.75, (double)9.25, (double)16.0, (double)9.25);
    private static final VoxelShape SHAPE_Z = Block.m_49796_((double)6.75, (double)6.75, (double)0.0, (double)9.25, (double)9.25, (double)16.0);

    public LaserFieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BOUNDTYPE, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.f_46443_ && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82750_((Entity)entity)).m_83215_().m_82338_(pos).m_82381_(entity.m_20191_())) {
                return;
            }
            for (int i = 0; i < (Integer)ConfigHandler.SERVER.laserBlockRange.get(); ++i) {
                OwnableEntity ownableEntity;
                Player player;
                BlockEntity blockEntity;
                BlockPos offsetPos = pos.m_5484_(LaserFieldBlock.getFieldDirection(state), i);
                BlockState offsetState = level.m_8055_(offsetPos);
                Block offsetBlock = offsetState.m_60734_();
                if (offsetBlock != SCContent.LASER_BLOCK.get() || !((blockEntity = level.m_7702_(offsetPos)) instanceof LaserBlockBlockEntity)) continue;
                LaserBlockBlockEntity laser = (LaserBlockBlockEntity)blockEntity;
                if (laser.isAllowed(entity) || laser.isConsideredInvisible(livingEntity)) {
                    return;
                }
                if (entity instanceof Player && laser.isOwnedBy((Entity)(player = (Player)entity)) && laser.ignoresOwner()) break;
                if (entity instanceof OwnableEntity && laser.allowsOwnableEntity(ownableEntity = (OwnableEntity)entity)) {
                    return;
                }
                if (laser.isModuleEnabled(ModuleType.REDSTONE)) {
                    if (laser.timeSinceLastToggle() < 500L) {
                        laser.setLastToggleTime(System.currentTimeMillis());
                    } else {
                        int signalLength = laser.getSignalLength();
                        boolean wasPowered = (Boolean)offsetState.m_61143_((Property)LaserBlock.POWERED);
                        laser.setLastToggleTime(System.currentTimeMillis());
                        level.m_46597_(offsetPos, (BlockState)offsetState.m_61122_((Property)LaserBlock.POWERED));
                        BlockUtils.updateIndirectNeighbors(level, offsetPos, (Block)SCContent.LASER_BLOCK.get());
                        laser.propagate(new ILinkedAction.StateChanged<Boolean>((Property<Boolean>)LaserBlock.POWERED, wasPowered, !wasPowered), laser);
                        if (signalLength > 0) {
                            level.m_186460_(offsetPos, (Block)SCContent.LASER_BLOCK.get(), signalLength);
                        }
                    }
                }
                if (!laser.isModuleEnabled(ModuleType.HARMING)) break;
                double damage = (Double)ConfigHandler.SERVER.laserDamage.get();
                livingEntity.m_6469_(CustomDamageSources.laser(level.m_9598_()), (float)damage);
                break;
            }
        }
    }

    public static Direction getFieldDirection(BlockState state) {
        return switch ((Integer)state.m_61143_((Property)BOUNDTYPE)) {
            case 1 -> Direction.UP;
            case 2 -> Direction.SOUTH;
            case 3 -> Direction.EAST;
            default -> null;
        };
    }

    public static int getBoundType(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP, Direction.DOWN -> 1;
            case Direction.NORTH, Direction.SOUTH -> 2;
            case Direction.EAST, Direction.WEST -> 3;
        };
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            int boundType = (Integer)state.m_61143_((Property)BOUNDTYPE);
            Direction direction = Direction.m_122376_((int)((boundType - 1) * 2));
            BlockUtils.removeInSequence((directionToCheck, stateToCheck) -> stateToCheck.m_60734_() == this && (Integer)stateToCheck.m_61143_((Property)BOUNDTYPE) == boundType, level, pos, direction, direction.m_122424_());
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Integer)state.m_61143_((Property)BOUNDTYPE)) {
            case 1 -> SHAPE_Y;
            case 2 -> SHAPE_Z;
            case 3 -> SHAPE_X;
            default -> Shapes.m_83040_();
        };
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getPotentiallyWaterloggedState(1, ctx.m_43725_(), ctx.m_8083_());
    }

    public BlockState getPotentiallyWaterloggedState(int boundType, Level level, BlockPos pos) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BOUNDTYPE, (Comparable)Integer.valueOf(boundType))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BOUNDTYPE, WATERLOGGED});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity((BlockEntityType)SCContent.ABSTRACT_BLOCK_ENTITY.get(), pos, state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        BlockState blockState;
        if (rot == Rotation.CLOCKWISE_180) {
            blockState = state;
        } else {
            blockState = (BlockState)state.m_61124_((Property)BOUNDTYPE, (Comparable)(switch ((Integer)state.m_61143_((Property)BOUNDTYPE)) {
                case 2 -> 3;
                case 3 -> 2;
                default -> 1;
            }));
        }
        return blockState;
    }
}

