/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.MineBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MineBlock
extends ExplosiveBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.m_61465_((String)"deactivated");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);

    public MineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (level.m_8055_(pos.m_7495_()).m_60795_()) {
            if (((Boolean)level.m_8055_(pos).m_61143_((Property)DEACTIVATED)).booleanValue()) {
                level.m_46961_(pos, true);
            } else {
                this.explode(level, pos);
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return BlockUtils.isSideSolid(level, pos.m_7495_(), Direction.UP);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.f_46443_) {
            MineBlockEntity mine = (MineBlockEntity)level.m_7702_(pos);
            TargetingMode mode = mine.getTargetingMode();
            if (!mode.allowsPlayers() || player != null && player.m_7500_() && !((Boolean)ConfigHandler.SERVER.mineExplodesWhenInCreative.get()).booleanValue()) {
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
            if (mine.isOwnedBy((Entity)player) && !mine.ignoresOwner()) {
                this.explode(level, pos);
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.f_46443_ && entity instanceof LivingEntity) {
            MineBlockEntity mine;
            TargetingMode mode;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82750_((Entity)entity)).m_83215_().m_82338_(pos).m_82400_(0.01).m_82381_(entity.m_20191_()) && (mode = (mine = (MineBlockEntity)level.m_7702_(pos)).getTargetingMode()).canAttackEntity(livingEntity, mine, e -> false)) {
                this.explode(level, pos);
            }
        }
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            level.m_142346_(null, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            level.m_142346_(null, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        if (!level.f_46443_ && !((Boolean)level.m_8055_(pos).m_61143_((Property)DEACTIVATED)).booleanValue()) {
            level.m_46961_(pos, false);
            level.m_255391_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 1.0f : 3.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DEACTIVATED, WATERLOGGED});
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        return (Boolean)level.m_8055_(pos).m_61143_((Property)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MineBlockEntity(pos, state);
    }
}

