/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.commands.LowercasedEnumArgument;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.FillCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.function.TriFunction;

public class ConvertCommand {
    private static final SimpleCommandExceptionType ERROR_SET_FAILED = new SimpleCommandExceptionType((Message)Component.m_264568_((String)"commands.securitycraft.convert.set.failed", (String)"There is no convertible block at the given position"));
    private static final SimpleCommandExceptionType ERROR_FILL_FAILED = new SimpleCommandExceptionType((Message)Component.m_264568_((String)"commands.securitycraft.convert.fill.failed", (String)"There are no convertible blocks in the given area"));

    private ConvertCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"convert").requires(ctx -> ctx.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"mode", LowercasedEnumArgument.enumArgument(ConversionMode.class)).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> ConvertCommand.set((CommandSourceStack)ctx.getSource(), (ConversionMode)((Object)((Object)ctx.getArgument("mode", ConversionMode.class))), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos")))))).then(Commands.m_82127_((String)"fill").then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> ConvertCommand.fill((CommandContext<CommandSourceStack>)ctx))))));
    }

    private static int set(CommandSourceStack source, ConversionMode mode, BlockPos pos) throws CommandSyntaxException {
        ServerLevel level = source.m_81372_();
        if (!mode.convert(level.m_8055_(pos), (Level)level, pos)) {
            throw ERROR_SET_FAILED.create();
        }
        source.m_288197_(() -> Component.m_264642_((String)"commands.securitycraft.convert.set.success", (String)"Converted the block at %s, %s, %s", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
        return 1;
    }

    private static int fill(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int commandModificationBlockLimit;
        ConversionMode mode = (ConversionMode)((Object)ctx.getArgument("mode", ConversionMode.class));
        BoundingBox area = BoundingBox.m_162375_((Vec3i)BlockPosArgument.m_118242_(ctx, (String)"from"), (Vec3i)BlockPosArgument.m_118242_(ctx, (String)"to"));
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.m_81372_();
        int blockCount = area.m_71056_() * area.m_71057_() * area.m_71058_();
        if (blockCount > (commandModificationBlockLimit = level.m_46469_().m_46215_(GameRules.f_263760_))) {
            throw FillCommand.f_137372_.create((Object)commandModificationBlockLimit, (Object)blockCount);
        }
        int blocksModified = 0;
        for (BlockPos pos : BlockPos.m_121976_((int)area.m_162395_(), (int)area.m_162396_(), (int)area.m_162398_(), (int)area.m_162399_(), (int)area.m_162400_(), (int)area.m_162401_())) {
            BlockState state = level.m_8055_(pos);
            if (!mode.convert(state, (Level)level, pos)) continue;
            ++blocksModified;
        }
        if (blocksModified == 0) {
            throw ERROR_FILL_FAILED.create();
        }
        int finalBlocksModified = blocksModified;
        source.m_288197_(() -> Component.m_264642_((String)"commands.securitycraft.convert.fill.success", (String)"Successfully converted %s block(s)", (Object[])new Object[]{finalBlocksModified}), true);
        return blocksModified;
    }

    private static enum ConversionMode {
        REINFORCE((TriFunction<BlockState, Level, BlockPos, Boolean>)((TriFunction)(state, level, pos) -> {
            Block block = state.m_60734_();
            if (IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.containsKey(block)) {
                level.m_46597_(pos, ((IReinforcedBlock)IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.get(block)).convertToReinforced((Level)level, (BlockPos)pos, (BlockState)state));
                return true;
            }
            return false;
        })),
        UNREINFORCE((TriFunction<BlockState, Level, BlockPos, Boolean>)((TriFunction)(state, level, pos) -> {
            Block block = state.m_60734_();
            if (IReinforcedBlock.SECURITYCRAFT_TO_VANILLA.containsKey(block)) {
                level.m_46597_(pos, ((IReinforcedBlock)block).convertToVanilla((Level)level, (BlockPos)pos, (BlockState)state));
                return true;
            }
            return false;
        })),
        PASSCODE_PROTECT((TriFunction<BlockState, Level, BlockPos, Boolean>)((TriFunction)(state, level, pos) -> {
            for (IPasscodeConvertible convertible : SecurityCraftAPI.getRegisteredPasscodeConvertibles()) {
                if (!convertible.isUnprotectedBlock((BlockState)state)) continue;
                return convertible.protect(null, (Level)level, (BlockPos)pos);
            }
            return false;
        })),
        REMOVE_PASSCODE_PROTECTION((TriFunction<BlockState, Level, BlockPos, Boolean>)((TriFunction)(state, level, pos) -> {
            for (IPasscodeConvertible convertible : SecurityCraftAPI.getRegisteredPasscodeConvertibles()) {
                if (!convertible.isProtectedBlock((BlockState)state)) continue;
                return convertible.unprotect(null, (Level)level, (BlockPos)pos);
            }
            return false;
        }));

        private final TriFunction<BlockState, Level, BlockPos, Boolean> converter;

        private ConversionMode(TriFunction<BlockState, Level, BlockPos, Boolean> converter) {
            this.converter = converter;
        }

        public boolean convert(BlockState state, Level level, BlockPos pos) {
            return (Boolean)this.converter.apply((Object)state, (Object)level, (Object)pos);
        }
    }
}

