/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class BlockEntityNBTCondition
implements LootItemCondition {
    private String key;
    private boolean value;

    private BlockEntityNBTCondition(String key, boolean value) {
        this.key = key;
        this.value = value;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return Set.of(LootContextParams.f_81460_);
    }

    public boolean test(LootContext lootContext) {
        BlockEntity be = (BlockEntity)lootContext.m_78953_(LootContextParams.f_81462_);
        if (be != null) {
            CompoundTag nbt = be.m_187480_();
            return nbt.m_128441_(this.key) && nbt.m_128471_(this.key) == this.value;
        }
        return false;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)SCContent.BLOCK_ENTITY_NBT.get();
    }

    public static ConditionBuilder builder() {
        return new ConditionBuilder();
    }

    public static class ConditionBuilder
    implements LootItemCondition.Builder {
        private String key;
        private boolean value;

        public ConditionBuilder equals(String key, boolean value) {
            this.key = key;
            this.value = value;
            return this;
        }

        public LootItemCondition m_6409_() {
            return new BlockEntityNBTCondition(this.key, this.value);
        }
    }

    public static class ConditionSerializer
    implements Serializer<BlockEntityNBTCondition> {
        public void serialize(JsonObject json, BlockEntityNBTCondition condition, JsonSerializationContext ctx) {
            json.addProperty("key", condition.key);
            json.addProperty("value", Boolean.valueOf(condition.value));
        }

        public BlockEntityNBTCondition deserialize(JsonObject json, JsonDeserializationContext ctx) {
            return new BlockEntityNBTCondition(GsonHelper.m_13906_((JsonObject)json, (String)"key"), GsonHelper.m_13912_((JsonObject)json, (String)"value"));
        }
    }
}

