/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.suspiciousmines;

import java.util.function.Predicate;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.blockentities.BrushableMineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BrushItem.class})
public class BrushItemMixin {
    @Inject(method={"calculateHitResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$makeSuspiciousMinesBrushablePartTwo(LivingEntity entity, CallbackInfoReturnable<HitResult> cir) {
        EntityHitResult hitResult1;
        Vec3 direction;
        Vec3 eyePosition = entity.m_146892_();
        Predicate<Entity> entitySelector = e -> {
            LivingEntity livingEntity;
            return (e instanceof LivingEntity ? (livingEntity = (LivingEntity)e).m_142065_() : !e.m_5833_()) && e.m_6087_();
        };
        Vec3 viewVector = entity.m_20252_(0.0f).m_82490_(5.0);
        Level level = entity.m_9236_();
        BlockHitResult hitResult = level.m_45547_(new ClipContext(eyePosition, direction = eyePosition.m_82549_(viewVector), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            direction = hitResult.m_82450_();
        }
        if ((hitResult1 = ProjectileUtil.m_37304_((Level)level, (Entity)entity, (Vec3)eyePosition, (Vec3)direction, (AABB)entity.m_20191_().m_82369_(viewVector).m_82400_(1.0), entitySelector)) != null) {
            hitResult = hitResult1;
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK && level.m_8055_(BlockPos.m_274446_((Position)hitResult.m_82450_())).m_204336_(SCTags.Blocks.SUSPICIOUS_MINES)) {
            cir.setReturnValue((Object)hitResult);
        }
    }

    @Inject(method={"onUseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isClientSide()Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void securitycraft$checkForSuspiciousMine(Level level, LivingEntity entity, ItemStack stack, int tick, CallbackInfo ci, Player player, HitResult hitResult, BlockHitResult blockHitResult, int i, boolean flag, BlockPos pos, BlockState brushedState) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && brushedState.m_204336_(SCTags.Blocks.SUSPICIOUS_MINES) && (blockEntity = level.m_7702_(pos)) instanceof BrushableMineBlockEntity) {
            BrushableMineBlockEntity be = (BrushableMineBlockEntity)blockEntity;
            boolean brushFinished = be.m_276923_(level.m_46467_(), player, blockHitResult.m_82434_());
            if (brushFinished) {
                stack.m_41622_(1, (LivingEntity)player, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
            }
            ci.cancel();
        }
    }
}

