/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class InteractWithFrame {
    private BlockPos pos;
    private boolean owner;

    public InteractWithFrame() {
    }

    public InteractWithFrame(BlockPos pos, boolean owner) {
        this.pos = pos;
        this.owner = owner;
    }

    public InteractWithFrame(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.owner = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.owner);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        Level level = Minecraft.m_91087_().f_91074_.m_9236_();
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (blockEntity instanceof FrameBlockEntity) {
            FrameBlockEntity be = (FrameBlockEntity)blockEntity;
            if (!be.redstoneSignalDisabled() && !be.hasClientInteracted() && be.getCurrentCamera() != null) {
                be.setCurrentCameraAndUpdate(be.getCurrentCamera());
            } else {
                ClientHandler.displayFrameScreen(be, !this.owner);
            }
        }
    }
}

