/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ToggleModule {
    private BlockPos pos;
    private ModuleType moduleType;
    private int entityId;

    public ToggleModule() {
    }

    public ToggleModule(BlockPos pos, ModuleType moduleType) {
        this.pos = pos;
        this.moduleType = moduleType;
    }

    public ToggleModule(int entityId, ModuleType moduleType) {
        this.entityId = entityId;
        this.moduleType = moduleType;
    }

    public ToggleModule(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.m_130135_();
        } else {
            this.entityId = buf.m_130242_();
        }
        this.moduleType = (ModuleType)buf.m_130066_(ModuleType.class);
    }

    public void encode(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.m_130064_(this.pos);
        } else {
            buf.m_130130_(this.entityId);
        }
        buf.m_130068_((Enum)this.moduleType);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        IOwnable ownable;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.m_9236_();
        IModuleInventory moduleInv = this.getModuleInventory(level);
        if (!(player.m_5833_() || moduleInv == null || moduleInv instanceof IOwnable && !(ownable = (IOwnable)((Object)moduleInv)).isOwnedBy((Entity)player))) {
            if (moduleInv.isModuleEnabled(this.moduleType)) {
                moduleInv.removeModule(this.moduleType, true);
                if (moduleInv instanceof LinkableBlockEntity) {
                    linkable = (LinkableBlockEntity)moduleInv;
                    linkable.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(this.moduleType, true), linkable);
                }
            } else {
                moduleInv.insertModule(moduleInv.getModule(this.moduleType), true);
                if (moduleInv instanceof LinkableBlockEntity) {
                    linkable = (LinkableBlockEntity)moduleInv;
                    ItemStack stack = moduleInv.getModule(this.moduleType);
                    linkable.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ModuleItem)stack.m_41720_(), true), linkable);
                }
            }
            if (moduleInv instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)moduleInv;
                player.m_9236_().m_7260_(this.pos, be.m_58900_(), be.m_58900_(), 3);
            }
        }
    }

    private IModuleInventory getModuleInventory(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (blockEntity instanceof IModuleInventory) {
                IModuleInventory be = (IModuleInventory)blockEntity;
                return be;
            }
        } else {
            Entity entity = level.m_6815_(this.entityId);
            if (entity instanceof IModuleInventory) {
                IModuleInventory entity2 = (IModuleInventory)entity;
                return entity2;
            }
        }
        return null;
    }
}

