/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ToggleOption {
    private BlockPos pos;
    private int optionId;
    private int entityId;

    public ToggleOption() {
    }

    public ToggleOption(BlockPos pos, int optionId) {
        this.pos = pos;
        this.optionId = optionId;
    }

    public ToggleOption(int entityId, int optionId) {
        this.entityId = entityId;
        this.optionId = optionId;
    }

    public ToggleOption(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.m_130135_();
        } else {
            this.entityId = buf.m_130242_();
        }
        this.optionId = buf.m_130242_();
    }

    public void encode(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.m_130064_(this.pos);
        } else {
            buf.m_130130_(this.entityId);
        }
        buf.m_130130_(this.optionId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        IOwnable ownable;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.m_9236_();
        ICustomizable customizable = this.getCustomizable(level);
        if (!(player.m_5833_() || customizable == null || customizable instanceof IOwnable && !(ownable = (IOwnable)((Object)customizable)).isOwnedBy((Entity)player))) {
            customizable.customOptions()[this.optionId].toggle();
            customizable.onOptionChanged(customizable.customOptions()[this.optionId]);
            if (customizable instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)customizable;
                level.m_7260_(this.pos, be.m_58900_(), be.m_58900_(), 3);
            }
        }
    }

    private ICustomizable getCustomizable(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (blockEntity instanceof ICustomizable) {
                ICustomizable be = (ICustomizable)blockEntity;
                return be;
            }
        } else {
            Entity entity = level.m_6815_(this.entityId);
            if (entity instanceof ICustomizable) {
                ICustomizable entity2 = (ICustomizable)entity;
                return entity2;
            }
        }
        return null;
    }
}

