/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class CollapsibleTextList
extends Button {
    private static final Component PLUS = Component.m_237113_((String)"+ ");
    private static final Component MINUS = Component.m_237113_((String)"- ");
    private final int threeDotsWidth;
    private final int maximumHeight;
    private int currentHeight;
    private int previousHeight;
    private final Component originalDisplayString;
    private final List<List<FormattedCharSequence>> textLines;
    private final BiPredicate<Integer, Integer> extraHoverCheck;
    private boolean open;
    private boolean isMessageTooLong;
    private int initialY;

    public CollapsibleTextList(int xPos, int yPos, int width, Component displayString, List<? extends Component> textLines, Button.OnPress onPress, BiPredicate<Integer, Integer> extraHoverCheck) {
        super(xPos, yPos, width, 12, displayString, onPress, s -> Component.m_237119_());
        this.threeDotsWidth = Minecraft.m_91087_().f_91062_.m_92895_("...");
        this.textLines = new ArrayList<List<FormattedCharSequence>>();
        this.open = true;
        this.isMessageTooLong = false;
        this.initialY = -1;
        this.originalDisplayString = displayString;
        this.switchOpenStatus();
        Font font = Minecraft.m_91087_().f_91062_;
        int amountOfLines = 0;
        for (Component component : textLines) {
            List splitLines = font.m_92923_((FormattedText)component, width - 5);
            amountOfLines += splitLines.size();
            this.textLines.add(splitLines);
        }
        Objects.requireNonNull(font);
        this.maximumHeight = this.f_93619_ + amountOfLines * 9 + textLines.size() * 3;
        this.currentHeight = this.previousHeight = this.f_93619_;
        this.extraHoverCheck = extraHoverCheck;
    }

    public void tick() {
        this.previousHeight = this.currentHeight;
        if (this.open) {
            if (this.currentHeight < this.maximumHeight) {
                this.currentHeight = Math.min(this.currentHeight + 40, this.maximumHeight);
            }
        } else if (this.currentHeight > this.f_93619_) {
            this.currentHeight = Math.max(this.f_93619_, this.currentHeight - 40);
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.f_93622_ &= this.extraHoverCheck.test(mouseX, mouseY);
        Font font = Minecraft.m_91087_().f_91062_;
        int v = !this.f_93623_ ? 0 : (this.m_198029_() ? 2 : 1);
        int heightOffset = (this.f_93619_ - 8) / 2;
        guiGraphics.blitWithBorder(f_93617_, this.m_252754_(), this.m_252907_(), 0, 46 + v * 20, this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
        guiGraphics.m_280653_(font, this.m_6035_(), this.m_252754_() + font.m_92852_((FormattedText)this.m_6035_()) / 2 + 3, this.m_252907_() + heightOffset, this.getFGColor());
        int renderedLines = 0;
        int interpolatedHeight = (int)Mth.m_14179_((float)partialTick, (float)this.previousHeight, (float)this.currentHeight);
        guiGraphics.m_280024_(this.m_252754_(), this.m_252907_() + this.f_93619_, this.m_252754_() + this.f_93618_, this.m_252907_() + interpolatedHeight, -1072689136, -804253680);
        for (int i = 0; i < this.textLines.size(); ++i) {
            int n = this.m_252907_() + 2 + this.f_93619_;
            Objects.requireNonNull(font);
            int textY = n + renderedLines * 9 + i * 12;
            List<FormattedCharSequence> linesToDraw = this.textLines.get(i);
            if (i > 0) {
                guiGraphics.m_280024_(this.m_252754_() + 1, textY - 3, this.m_252754_() + this.f_93618_ - 2, textY - 2, -1432313696, -1432313696);
            }
            for (int lineIndex = 0; lineIndex < linesToDraw.size(); ++lineIndex) {
                Objects.requireNonNull(font);
                int lineY = textY + lineIndex * 9;
                Objects.requireNonNull(font);
                if (lineY + 9 > this.m_252907_() + interpolatedHeight) {
                    return;
                }
                guiGraphics.m_280649_(font, linesToDraw.get(lineIndex), this.m_252754_() + 2, lineY, this.getFGColor(), false);
            }
            renderedLines += linesToDraw.size() - 1;
        }
    }

    public void renderLongMessageTooltip(GuiGraphics guiGraphics, Font font) {
        Screen currentScreen;
        if (this.isMessageTooLong && this.m_198029_() && (currentScreen = Minecraft.m_91087_().f_91080_) != null) {
            guiGraphics.m_280557_(font, this.originalDisplayString, this.m_252754_() + 1, this.m_252907_() + this.f_93619_ + 2);
        }
    }

    public void m_93666_(Component message) {
        int cutoff;
        Font font = Minecraft.m_91087_().f_91062_;
        int stringWidth = font.m_92852_((FormattedText)message);
        if (stringWidth > (cutoff = this.f_93618_ - 6) && stringWidth > this.threeDotsWidth) {
            this.isMessageTooLong = true;
            message = Component.m_237113_((String)(font.m_92854_((FormattedText)message, cutoff - this.threeDotsWidth).getString() + "..."));
        }
        super.m_93666_(message);
    }

    public int m_93694_() {
        return this.currentHeight;
    }

    public int getMaximumHeight() {
        return this.open ? this.maximumHeight : this.f_93619_;
    }

    public void m_5691_() {
        this.switchOpenStatus();
        super.m_5691_();
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.m_5953_(mouseX, mouseY);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.extraHoverCheck.test((int)mouseX, (int)mouseY) && super.m_5953_(mouseX, mouseY);
    }

    public void m_253211_(int y) {
        if (this.initialY == -1) {
            this.initialY = y;
        }
        super.m_253211_(y);
    }

    public void switchOpenStatus() {
        this.open = !this.open;
        this.m_93666_((Component)(this.open ? MINUS : PLUS).m_6881_().m_7220_(this.originalDisplayString));
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getInitialY() {
        return this.initialY;
    }
}

