/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class BlockEntityRenderDelegate {
    private final Map<BlockEntity, DelegateRendererInfo> renderDelegates = new HashMap<BlockEntity, DelegateRendererInfo>();

    public void putDelegateFor(BlockEntity originalBlockEntity, BlockState delegateState, ItemStack stack) {
        if (this.renderDelegates.containsKey(originalBlockEntity)) {
            DelegateRendererInfo delegateInfo = this.renderDelegates.get(originalBlockEntity);
            if (delegateInfo.delegateBlockEntity.m_58900_().m_60734_() == delegateState.m_60734_()) {
                delegateInfo.delegateBlockEntity.m_155250_(delegateState);
                return;
            }
        }
        if (delegateState != null && delegateState.m_155947_()) {
            Minecraft mc = Minecraft.m_91087_();
            BlockEntity delegateBe = ((EntityBlock)delegateState.m_60734_()).m_142194_(BlockPos.f_121853_, delegateState);
            if (delegateBe != null) {
                delegateBe.m_142339_((Level)mc.f_91073_);
                Utils.updateBlockEntityWithItemTag(delegateBe, stack);
                BlockEntityRenderer delegateBeRenderer = mc.m_167982_().m_112265_(delegateBe);
                if (delegateBeRenderer != null) {
                    this.renderDelegates.put(originalBlockEntity, new DelegateRendererInfo(delegateBe, delegateBeRenderer));
                }
            }
        }
    }

    public void removeDelegateOf(BlockEntity originalBlockEntity) {
        this.renderDelegates.remove(originalBlockEntity);
    }

    public boolean tryRenderDelegate(BlockEntity originalBlockEntity, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        DelegateRendererInfo delegateRendererInfo = this.renderDelegates.get(originalBlockEntity);
        if (delegateRendererInfo != null) {
            try {
                PoseStack copyPose = new PoseStack();
                copyPose.m_85836_();
                copyPose.m_85850_().m_252922_().mul((Matrix4fc)pose.m_85850_().m_252922_());
                copyPose.m_85850_().m_252943_().mul((Matrix3fc)pose.m_85850_().m_252943_());
                delegateRendererInfo.delegateRenderer().m_6922_(delegateRendererInfo.delegateBlockEntity(), partialTicks, copyPose, buffer, combinedLight, combinedOverlay);
                copyPose.m_85849_();
            }
            catch (Exception e) {
                SecurityCraft.LOGGER.warn("Error when delegate-rendering {}", (Object)ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)delegateRendererInfo.delegateBlockEntity().m_58903_()));
                e.printStackTrace();
                this.removeDelegateOf(originalBlockEntity);
            }
            return true;
        }
        return false;
    }

    private record DelegateRendererInfo(BlockEntity delegateBlockEntity, BlockEntityRenderer delegateRenderer) {
    }
}

