/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerUtils {
    private PlayerUtils() {
    }

    public static <T extends Player> T getPlayerFromName(String name) {
        List players = null;
        players = EffectiveSide.get() == LogicalSide.CLIENT ? Minecraft.m_91087_().f_91073_.m_6907_() : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
        if (players != null) {
            for (Player player : players) {
                if (!player.m_7755_().getString().equals(name)) continue;
                return (T)player;
            }
        }
        return null;
    }

    public static boolean isPlayerOnline(String name) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            for (AbstractClientPlayer player : Minecraft.m_91087_().f_91073_.m_6907_()) {
                if (player == null || !player.m_7755_().getString().equals(name)) continue;
                return true;
            }
            return false;
        }
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(name) != null;
    }

    public static void sendMessageToPlayer(String playerName, MutableComponent prefix, MutableComponent text, ChatFormatting color) {
        Object player = PlayerUtils.getPlayerFromName(playerName);
        if (player != null) {
            PlayerUtils.sendMessageToPlayer(player, prefix, text, color, false);
        }
    }

    public static void sendMessageToPlayer(Player player, MutableComponent prefix, MutableComponent text, ChatFormatting color) {
        PlayerUtils.sendMessageToPlayer(player, prefix, text, color, false);
    }

    public static void sendMessageToPlayer(Player player, MutableComponent prefix, MutableComponent text, ChatFormatting color, boolean shouldSendFromClient) {
        if (player != null && player.m_9236_().f_46443_ == shouldSendFromClient) {
            player.m_213846_((Component)Component.m_237113_((String)"[").m_7220_((Component)prefix.m_6270_(Style.f_131099_.m_131140_(color))).m_7220_((Component)Component.m_237113_((String)"] ")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE)).m_7220_((Component)text));
        }
    }

    public static ItemStack getItemStackFromAnyHand(Player player, Item item) {
        Inventory inventory = player.m_150109_();
        if (inventory.m_36056_().m_150930_(item)) {
            return inventory.m_36056_();
        }
        if (((ItemStack)inventory.f_35976_.get(0)).m_150930_(item)) {
            return (ItemStack)inventory.f_35976_.get(0);
        }
        return ItemStack.f_41583_;
    }

    public static boolean isPlayerMountedOnCamera(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (player.m_9236_().f_46443_) {
            return ClientHandler.isPlayerMountedOnCamera();
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.m_8954_() instanceof SecurityCamera;
        }
        return false;
    }

    public static Component getOwnerComponent(Owner owner) {
        TeamUtils.TeamRepresentation teamRepresentation = TeamUtils.getTeamRepresentation(owner);
        if (teamRepresentation != null) {
            return Utils.localize("messages.securitycraft:teamOwner", Component.m_237113_((String)teamRepresentation.name()).m_130948_(Style.f_131099_.m_178520_(teamRepresentation.color()))).m_130940_(ChatFormatting.GRAY);
        }
        return Component.m_237113_((String)owner.getName());
    }

    public static Owner getSkullOwner(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.HEAD);
        if (stack.m_41720_() == Items.f_42680_ && stack.m_41782_()) {
            CompoundTag stackTag = stack.m_41783_();
            if (stackTag.m_128425_("SkullOwner", 8)) {
                return new Owner(stackTag.m_128461_("SkullOwner"), "ownerUUID");
            }
            if (stackTag.m_128425_("SkullOwner", 10)) {
                GameProfile profile = NbtUtils.m_129228_((CompoundTag)stackTag.m_128469_("SkullOwner"));
                String name = "ownerName";
                String uuid = "ownerUUID";
                if (profile.getName() != null) {
                    name = profile.getName();
                }
                if (profile.getId() != null) {
                    uuid = profile.getId().toString();
                }
                return new Owner(name, uuid);
            }
        }
        return null;
    }

    public static Collection<ServerPlayer> getPlayerListFromOwner(Owner owner) {
        ServerPlayer player = (ServerPlayer)PlayerUtils.getPlayerFromName(owner.getName());
        if (player != null) {
            return Arrays.asList(player);
        }
        return new ArrayList<ServerPlayer>();
    }
}

