/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.network;

import glitchcore.network.CustomPacket;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import sereneseasons.season.SeasonHandlerClient;

public class SyncSeasonCyclePacket
implements CustomPacket<SyncSeasonCyclePacket> {
    public ResourceKey<Level> dimension;
    public int seasonCycleTicks;

    public SyncSeasonCyclePacket() {
    }

    public SyncSeasonCyclePacket(ResourceKey<Level> dimension, int seasonCycleTicks) {
        this.dimension = dimension;
        this.seasonCycleTicks = seasonCycleTicks;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.dimension.m_135782_().toString());
        buf.writeInt(this.seasonCycleTicks);
    }

    public SyncSeasonCyclePacket decode(FriendlyByteBuf buf) {
        return new SyncSeasonCyclePacket((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buf.m_130277_())), buf.readInt());
    }

    public void handle(SyncSeasonCyclePacket packet, CustomPacket.Context context) {
        context.getPlayer().ifPresent(player -> {
            ResourceKey playerDimension = player.m_9236_().m_46472_();
            if (playerDimension.equals(packet.dimension)) {
                SeasonHandlerClient.clientSeasonCycleTicks.put((ResourceKey<Level>)playerDimension, packet.seasonCycleTicks);
            }
        });
    }
}

