/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.peaceful_hunger.core.registry;

import forge.com.cursee.peaceful_hunger.core.registry.ModBlocks;
import forge.com.cursee.peaceful_hunger.core.registry.ModItems;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class RegistryForge {
    private static final Set<Item> CREATIVE_MODE_TAB_ITEMS = new LinkedHashSet<Item>();

    public static void register(IEventBus modEventBus) {
        RegistryForge.bind(Registries.f_256747_, consumer -> ModBlocks.register(consumer));
        RegistryForge.bindForItems(ModItems::register);
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private static void bindForItems(Consumer<BiConsumer<Item, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (event.getRegistryKey().equals((Object)Registries.f_256913_)) {
                source.accept((t, rl) -> {
                    CREATIVE_MODE_TAB_ITEMS.add((Item)t);
                    event.register(Registries.f_256913_, rl, () -> t);
                });
            }
        });
    }
}

