/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client;

import bagu_chan.bagus_lib.CommonEvent;
import bagu_chan.bagus_lib.animation.BaguAnimationController;
import bagu_chan.bagus_lib.api.IBaguAnimate;
import bagu_chan.bagus_lib.api.client.IRootModel;
import bagu_chan.bagus_lib.client.animation.TestAnimations;
import bagu_chan.bagus_lib.client.event.BagusModelEvent;
import bagu_chan.bagus_lib.util.DialogHandler;
import bagu_chan.bagus_lib.util.client.AnimationUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="bagus_lib")
public class ClientEventHandler {
    private static boolean initDate = false;
    private static boolean aprilFools = false;

    @SubscribeEvent
    public static void clientLoggOut(PlayerEvent.PlayerLoggedOutEvent event) {
        DialogHandler.INSTANCE.removeAllDialogType();
    }

    @SubscribeEvent
    public static void clientRespawn(PlayerEvent.PlayerRespawnEvent event) {
        DialogHandler.INSTANCE.removeAllDialogType();
    }

    @SubscribeEvent
    public static void animationEvent(BagusModelEvent.Init bagusModelEvent) {
        IRootModel rootModel = bagusModelEvent.getRootModel();
        if (bagusModelEvent.isSupportedAnimateModel()) {
            rootModel.getBagusRoot().m_171331_().forEach(ModelPart::m_233569_);
        }
    }

    @SubscribeEvent
    public static void animationEvent(BagusModelEvent.PostAnimate bagusModelEvent) {
        IRootModel rootModel = bagusModelEvent.getRootModel();
        BaguAnimationController animationController = AnimationUtil.getAnimationController(bagusModelEvent.getEntity());
        if (bagusModelEvent.isSupportedAnimateModel() && animationController != null && rootModel.getBagusRoot() != null) {
            rootModel.animateBagu(animationController.getAnimationState(CommonEvent.TEST), TestAnimations.ATTACK, bagusModelEvent.getAgeInTick());
        }
    }

    @SubscribeEvent
    public static void animationArmEvent(RenderHandEvent event) {
        IBaguAnimate baguAnimate;
        boolean playFlag;
        LocalPlayer abstractClientPlayer = Minecraft.m_91087_().f_91074_;
        PlayerRenderer playerrenderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)abstractClientPlayer);
        EntityModel entityModel = playerrenderer.m_7200_();
        if (abstractClientPlayer instanceof IBaguAnimate && (playFlag = (baguAnimate = (IBaguAnimate)abstractClientPlayer).getBaguController().hasPlayingAnimation())) {
            ClientEventHandler.renderArmWithItem((AbstractClientPlayer)abstractClientPlayer, event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), entityModel);
            event.setCanceled(true);
        }
    }

    private static void renderArmWithItem(AbstractClientPlayer p_109372_, InteractionHand p_109375_, float p_109376_, ItemStack p_109377_, float p_109378_, PoseStack p_109379_, MultiBufferSource p_109380_, int p_109381_, EntityModel entityModel) {
        if (!p_109372_.m_150108_()) {
            boolean flag = p_109375_ == InteractionHand.MAIN_HAND;
            HumanoidArm humanoidarm = flag ? p_109372_.m_5737_() : p_109372_.m_5737_().m_20828_();
            boolean flag2 = humanoidarm == HumanoidArm.RIGHT;
            p_109379_.m_85836_();
            if (!p_109372_.m_20145_()) {
                boolean flag3;
                p_109379_.m_85836_();
                ClientEventHandler.renderPlayerArm(p_109379_, p_109380_, p_109381_, p_109378_, p_109376_, humanoidarm, entityModel);
                boolean bl = flag3 = humanoidarm == HumanoidArm.LEFT;
                if (entityModel instanceof PlayerModel) {
                    PlayerModel playerModel = (PlayerModel)entityModel;
                    playerModel.m_6002_(humanoidarm, p_109379_);
                    p_109379_.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    p_109379_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    p_109379_.m_252880_((float)(flag3 ? -1 : 1) / 16.0f, 0.125f, -0.625f);
                }
                ClientEventHandler.renderItem((LivingEntity)p_109372_, p_109377_, flag3 ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, p_109379_, p_109380_, p_109381_, flag2);
                p_109379_.m_85849_();
            }
            p_109379_.m_85849_();
        }
    }

    private static void renderItem(LivingEntity p_270072_, ItemStack p_270793_, ItemDisplayContext p_270837_, PoseStack p_270974_, MultiBufferSource p_270686_, int p_270103_, boolean rightHand) {
        if (!p_270793_.m_41619_()) {
            Minecraft.m_91087_().m_91291_().m_269491_(p_270072_, p_270793_, p_270837_, !rightHand, p_270974_, p_270686_, p_270072_.m_9236_(), p_270103_, OverlayTexture.f_118083_, p_270072_.m_19879_() + p_270837_.ordinal());
        }
    }

    private static void renderPlayerArm(PoseStack p_109347_, MultiBufferSource p_109348_, int p_109349_, float p_109350_, float p_109351_, HumanoidArm p_109352_, EntityModel entityModel) {
        boolean flag = p_109352_ != HumanoidArm.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = Mth.m_14116_((float)p_109351_);
        float f2 = -0.3f * Mth.m_14031_((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * Mth.m_14031_((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * Mth.m_14031_((float)(p_109351_ * (float)Math.PI));
        p_109347_.m_252880_(f * (f2 + 0.64000005f), f3 + -0.6f + p_109350_ * -0.6f, f4 + -0.71999997f);
        p_109347_.m_252781_(Axis.f_252436_.m_252977_(f * 45.0f));
        float f5 = Mth.m_14031_((float)(p_109351_ * p_109351_ * (float)Math.PI));
        float f6 = Mth.m_14031_((float)(f1 * (float)Math.PI));
        p_109347_.m_252781_(Axis.f_252436_.m_252977_(f * f6 * 70.0f));
        p_109347_.m_252781_(Axis.f_252403_.m_252977_(f * f5 * -20.0f));
        LocalPlayer abstractclientplayer = Minecraft.m_91087_().f_91074_;
        p_109347_.m_252880_(f * -1.0f, 3.6f, 3.5f);
        p_109347_.m_252781_(Axis.f_252403_.m_252977_(f * 120.0f));
        p_109347_.m_252781_(Axis.f_252529_.m_252977_(200.0f));
        p_109347_.m_252781_(Axis.f_252436_.m_252977_(f * -135.0f));
        p_109347_.m_252880_(f * 5.6f, 0.0f, 0.0f);
        ResourceLocation resourcelocation = abstractclientplayer.m_108560_();
        if (flag) {
            ClientEventHandler.renderRightHand(p_109347_, p_109348_, p_109349_, resourcelocation, abstractclientplayer.m_36170_(PlayerModelPart.RIGHT_SLEEVE), (AbstractClientPlayer)abstractclientplayer, entityModel);
        } else {
            ClientEventHandler.renderLeftHand(p_109347_, p_109348_, p_109349_, resourcelocation, abstractclientplayer.m_36170_(PlayerModelPart.LEFT_SLEEVE), (AbstractClientPlayer)abstractclientplayer, entityModel);
        }
    }

    public static void renderRightHand(PoseStack p_117771_, MultiBufferSource p_117772_, int p_117773_, ResourceLocation p_363694_, boolean p_366898_, AbstractClientPlayer player, EntityModel entityModel) {
        if (!ForgeHooksClient.renderSpecificFirstPersonArm((PoseStack)p_117771_, (MultiBufferSource)p_117772_, (int)p_117773_, (AbstractClientPlayer)player, (HumanoidArm)HumanoidArm.RIGHT) && entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            ClientEventHandler.renderHand(p_117771_, p_117772_, p_117773_, p_363694_, playerModel.f_102811_, p_366898_, playerModel);
        }
    }

    public static void renderLeftHand(PoseStack p_117814_, MultiBufferSource p_117815_, int p_117816_, ResourceLocation p_361745_, boolean p_366730_, AbstractClientPlayer player, EntityModel entityModel) {
        if (!ForgeHooksClient.renderSpecificFirstPersonArm((PoseStack)p_117814_, (MultiBufferSource)p_117815_, (int)p_117816_, (AbstractClientPlayer)player, (HumanoidArm)HumanoidArm.LEFT) && entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            ClientEventHandler.renderHand(p_117814_, p_117815_, p_117816_, p_361745_, playerModel.f_102812_, p_366730_, playerModel);
        }
    }

    private static void renderHand(PoseStack p_117776_, MultiBufferSource p_117777_, int p_117778_, ResourceLocation p_360319_, ModelPart p_117780_, boolean p_366655_, PlayerModel playermodel) {
        p_117780_.m_233569_();
        p_117780_.f_104207_ = true;
        playermodel.f_103374_.f_104207_ = p_366655_;
        playermodel.f_103375_.f_104207_ = p_366655_;
        LocalPlayer abstractClientPlayer = Minecraft.m_91087_().f_91074_;
        if (abstractClientPlayer != null) {
            PlayerRenderer playerrenderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)abstractClientPlayer);
            EntityModel entityModel = playerrenderer.m_7200_();
            if (abstractClientPlayer instanceof IBaguAnimate) {
                IBaguAnimate baguAnimate = (IBaguAnimate)abstractClientPlayer;
                BagusModelEvent.PostAnimate event2 = new BagusModelEvent.PostAnimate((LivingEntity)abstractClientPlayer, entityModel, Minecraft.m_91087_().m_91297_());
                MinecraftForge.EVENT_BUS.post((Event)event2);
            }
        }
        p_117780_.m_104301_(p_117776_, p_117777_.m_6299_(RenderType.m_110473_((ResourceLocation)p_360319_)), p_117778_, OverlayTexture.f_118083_);
    }
}

