/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import com.teammetallurgy.aquaculture.entity.TurtleLandEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class TurtleLandModel<T extends TurtleLandEntity>
extends QuadrupedModel<T> {
    private final ModelPart tail;
    private final ModelPart shellTop;
    private final ModelPart belly;

    public TurtleLandModel(ModelPart part) {
        super(part, false, 1.1f, 1.5f, 2.0f, 2.0f, 24);
        this.tail = part.m_171324_("tail");
        this.shellTop = part.m_171324_("shell_top");
        this.belly = part.m_171324_("belly");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelDefinition = new MeshDefinition();
        PartDefinition def = modelDefinition.m_171576_();
        def.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)22.2f, (float)-4.0f));
        def.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -1.0f, -3.0f, 5.0f, 2.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)0.0f));
        def.m_171599_("belly", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-2.0f, -0.5f, -2.5f, 4.0f, 1.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)0.0f));
        def.m_171599_("shell_top", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(-2.0f, -0.5f, -2.5f, 4.0f, 1.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)20.5f, (float)0.0f));
        def.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(16, 3).m_171481_(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.m_171423_((float)-2.5f, (float)23.0f, (float)3.0f, (float)0.5235988f, (float)5.7595863f, (float)0.0f));
        def.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.m_171423_((float)2.5f, (float)23.0f, (float)-3.0f, (float)-0.5235988f, (float)-0.5235988f, (float)0.0f));
        def.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(20, 3).m_171481_(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.m_171423_((float)-2.5f, (float)23.0f, (float)-3.0f, (float)-0.5235988f, (float)0.5235988f, (float)0.0f));
        def.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171481_(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.m_171423_((float)2.5f, (float)23.0f, (float)3.0f, (float)0.5235988f, (float)0.5235988f, (float)0.0f));
        def.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171481_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)22.5f, (float)3.2f));
        return LayerDefinition.m_171565_((MeshDefinition)modelDefinition, (int)64, (int)32);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_103493_, (Object)this.f_170852_, (Object)this.f_170853_, (Object)this.f_170854_, (Object)this.f_170855_, (Object)this.tail, (Object)this.shellTop, (Object)this.belly);
    }

    public void setupAnim(@Nonnull T turtle, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.f_103492_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_103492_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_170852_.f_104203_ = 0.5235988f + Mth.m_14089_((float)(limbSwing * 5.0f)) * 1.4f * limbSwingAmount;
        this.f_170853_.f_104203_ = -0.5235988f + -(Mth.m_14089_((float)(limbSwing * 5.0f)) * 1.4f * limbSwingAmount);
        this.f_170854_.f_104203_ = -0.5235988f + -(Mth.m_14089_((float)(limbSwing * 5.0f)) * 1.4f * limbSwingAmount);
        this.f_170855_.f_104203_ = 0.5235988f + Mth.m_14089_((float)(limbSwing * 5.0f)) * 1.4f * limbSwingAmount;
        this.tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.4662f)) * 0.6f * limbSwingAmount;
    }
}

