/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ItemFilletKnife
extends SwordItem {
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> attributes;

    public ItemFilletKnife(Tier material) {
        super(material, 0, 0.0f, new Item.Properties().m_41499_(material == AquacultureAPI.MATS.NEPTUNIUM ? -1 : (int)((float)material.m_6609_() * 0.75f)));
        this.attackDamage = material.m_6631_() / 2.0f;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.2f, AttributeModifier.Operation.ADDITION));
        this.attributes = builder.build();
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && this.canApplyEnchantment(enchantment);
    }

    private boolean canApplyEnchantment(Enchantment enchantment) {
        return enchantment != Enchantments.f_44982_ && enchantment != Enchantments.f_44983_;
    }

    public float m_43299_() {
        return this.attackDamage;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> m_7167_(@Nonnull EquipmentSlot slotType) {
        return slotType == EquipmentSlot.MAINHAND ? this.attributes : ImmutableMultimap.of();
    }

    public boolean canPerformAction(@Nonnull ItemStack stack, @Nonnull ToolAction toolAction) {
        return toolAction == ToolActions.SWORD_DIG;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag tooltipFlag) {
        if (this.m_43314_() == AquacultureAPI.MATS.NEPTUNIUM) {
            MutableComponent unbreakable = Component.m_237115_((String)"aquaculture.unbreakable");
            tooltip.add((Component)unbreakable.m_130948_(unbreakable.m_7383_().m_131140_(ChatFormatting.DARK_GRAY).m_131136_(Boolean.valueOf(true))));
        }
        super.m_7373_(stack, world, tooltip, tooltipFlag);
    }
}

