/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class LootBoxItem
extends Item {
    private final ResourceLocation lootTable;

    public LootBoxItem(ResourceLocation lootTable) {
        super(new Item.Properties());
        this.lootTable = lootTable;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (world.f_46443_ || this.lootTable == null) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldStack);
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            LootParams.Builder builder = new LootParams.Builder(serverLevel);
            ObjectArrayList loot = serverLevel.m_7654_().m_278653_().m_278676_(this.lootTable).m_287195_(builder.m_287235_(LootContextParamSets.f_81410_));
            if (!loot.isEmpty()) {
                ItemStack lootStack = (ItemStack)loot.get(0);
                player.m_5661_((Component)Component.m_237110_((String)"aquaculture.loot.open", (Object[])new Object[]{lootStack.m_41786_()}).m_130940_(ChatFormatting.YELLOW), true);
                this.giveItem(player, lootStack);
                heldStack.m_41774_(1);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldStack);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    private void giveItem(Player player, @Nonnull ItemStack stack) {
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_36176_(stack, false);
        } else if (player instanceof ServerPlayer) {
            player.f_36095_.m_150429_();
        }
    }
}

