/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.recipe;

import com.google.gson.JsonObject;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.forge.TemplateRecipeManagerImpl;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.recipe.ShapedRecipeTemplate;
import net.mehvahdjukaar.moonlight.core.recipe.ShapelessRecipeTemplate;
import net.mehvahdjukaar.moonlight.core.recipe.SmeltingRecipeTemplate;
import net.mehvahdjukaar.moonlight.core.recipe.StoneCutterRecipeTemplate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;

public class TemplateRecipeManager {
    private static final Map<ResourceLocation, Function<JsonObject, ? extends IRecipeTemplate<?>>> DESERIALIZERS = new HashMap();

    public static <T extends IRecipeTemplate<?>> void registerTemplate(RecipeSerializer<?> serializer, Function<JsonObject, T> deserializer) {
        TemplateRecipeManager.registerTemplate(Utils.getID(serializer), deserializer);
    }

    public static <T extends IRecipeTemplate<?>> void registerTemplate(ResourceLocation serializerId, Function<JsonObject, T> deserializer) {
        DESERIALIZERS.put(serializerId, deserializer);
    }

    public static IRecipeTemplate<?> read(JsonObject recipe) throws UnsupportedOperationException {
        String type = GsonHelper.m_13906_((JsonObject)recipe, (String)"type");
        Function<JsonObject, IRecipeTemplate<?>> templateFactory = DESERIALIZERS.get(new ResourceLocation(type));
        if (templateFactory != null) {
            ShapedRecipeTemplate st;
            ShapelessRecipeTemplate template = templateFactory.apply(recipe);
            if (template instanceof ShapedRecipeTemplate && (st = (ShapedRecipeTemplate)((Object)template)).shouldBeShapeless()) {
                template = st.toShapeless();
            }
            TemplateRecipeManager.addRecipeConditions(recipe, template);
            return template;
        }
        throw new UnsupportedOperationException(String.format("Invalid recipe serializer: %s. Supported deserializers: %s", type, DESERIALIZERS.keySet()));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void addRecipeConditions(JsonObject recipe, IRecipeTemplate<?> template) {
        void var1_1;
        TemplateRecipeManagerImpl.addRecipeConditions(recipe, var1_1);
    }

    private static IRecipeTemplate<?> forgeConditional(JsonObject recipe) {
        JsonObject object = GsonHelper.m_13933_((JsonObject)recipe, (String)"recipes").get(0).getAsJsonObject();
        IRecipeTemplate<?> template = TemplateRecipeManager.read(object.getAsJsonObject("recipe"));
        TemplateRecipeManager.addRecipeConditions(object, template);
        return template;
    }

    static {
        TemplateRecipeManager.registerTemplate(RecipeSerializer.f_44076_, ShapedRecipeTemplate::new);
        TemplateRecipeManager.registerTemplate(RecipeSerializer.f_44077_, ShapelessRecipeTemplate::new);
        TemplateRecipeManager.registerTemplate(RecipeSerializer.f_44095_, StoneCutterRecipeTemplate::new);
        TemplateRecipeManager.registerTemplate(RecipeSerializer.f_44091_, (JsonObject j) -> new SmeltingRecipeTemplate((JsonObject)j, (SimpleCookingSerializer<?>)((SimpleCookingSerializer)RecipeSerializer.f_44091_)));
        TemplateRecipeManager.registerTemplate(RecipeSerializer.f_44092_, (JsonObject j) -> new SmeltingRecipeTemplate((JsonObject)j, (SimpleCookingSerializer<?>)((SimpleCookingSerializer)RecipeSerializer.f_44092_)));
        TemplateRecipeManager.registerTemplate(RecipeSerializer.f_44093_, (JsonObject j) -> new SmeltingRecipeTemplate((JsonObject)j, (SimpleCookingSerializer<?>)((SimpleCookingSerializer)RecipeSerializer.f_44093_)));
        TemplateRecipeManager.registerTemplate(RecipeSerializer.f_44094_, (JsonObject j) -> new SmeltingRecipeTemplate((JsonObject)j, (SimpleCookingSerializer<?>)((SimpleCookingSerializer)RecipeSerializer.f_44094_)));
        TemplateRecipeManager.registerTemplate(new ResourceLocation("forge:conditional"), TemplateRecipeManager::forgeConditional);
    }
}

