/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.leaves;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.DebugBlockTypes;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeavesType
extends BlockType {
    public static final Codec<LeavesType> CODEC = ResourceLocation.f_135803_.flatXmap(r -> {
        LeavesType w = (LeavesType)LeavesTypeRegistry.INSTANCE.get((ResourceLocation)r);
        if (w == null) {
            return DataResult.error(() -> "No such leaves type: " + String.valueOf(r));
        }
        return DataResult.success((Object)w);
    }, t -> DataResult.success((Object)t.id));
    public final Block leaves;

    protected LeavesType(ResourceLocation id, Block leaves) {
        super(id);
        this.leaves = leaves;
        if (ClientConfigs.LEAVESTYPE_DEBUG.get().booleanValue() && !this.isVanilla()) {
            DebugBlockTypes.appendToDebugFile(this.getTranslationKey());
        }
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public WoodType getWoodType() {
        WoodType w = this.getAssociatedWoodType();
        if (w == null) {
            return WoodTypeRegistry.OAK_TYPE;
        }
        return w;
    }

    @Nullable
    public WoodType getAssociatedWoodType() {
        return LeavesTypeRegistry.INSTANCE.getEquivalentWoodType(this);
    }

    @Override
    public ItemLike mainChild() {
        return this.leaves;
    }

    @Override
    public String getTranslationKey() {
        return "leaves_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("leaves", this.leaves);
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("sapling", this.findRelatedEntry("sapling", BuiltInRegistries.f_257033_));
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<LeavesType> {
        private Supplier<Block> leavesFinder;

        public Finder(ResourceLocation id) {
            super(id);
            this.leavesSuffix("_leaves");
        }

        public Finder leaves(Supplier<Block> planksFinder) {
            this.leavesFinder = planksFinder;
            return this;
        }

        public Finder leaves(ResourceLocation id) {
            return this.leaves(() -> (Block)BuiltInRegistries.f_256975_.m_6612_(id).orElseThrow(() -> new IllegalStateException("Failed to find leaves block: " + String.valueOf(id))));
        }

        public Finder leavesAffix(String prefix, String suffix) {
            return this.leaves(prefix + this.id.m_135815_() + suffix);
        }

        public Finder leavesSuffix(String suffix) {
            return this.leaves(this.id.m_135815_() + suffix);
        }

        public Finder leaves(String leavesName) {
            return this.leaves(Utils.idWithOptionalNamespace(leavesName, this.id.m_135827_()));
        }

        public Finder equivalentWood(String id) {
            LeavesTypeRegistry.INSTANCE.addLeavesToWoodMapping(this.id, new ResourceLocation(id));
            return this;
        }

        @Override
        public Optional<LeavesType> get() {
            if (PlatHelper.isModLoaded(this.id.m_135827_())) {
                try {
                    Block leaves = (Block)Preconditions.checkNotNull((Object)this.leavesFinder.get(), (String)"Manual finder {} did not find a Leaf Block", (Object)this.id);
                    LeavesType w = new LeavesType(this.id, leaves);
                    this.childNames.forEach((key, value) -> {
                        try {
                            ItemLike obj = (ItemLike)Preconditions.checkNotNull((Object)((ItemLike)value.get()));
                            w.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            Moonlight.LOGGER.warn("Failed to find child for wood type {}: {}. Ignoring", (Object)this.id, key, (Object)e);
                        }
                    });
                    return Optional.of(w);
                }
                catch (Exception e) {
                    Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }

        @Deprecated(forRemoval=true)
        public Finder(ResourceLocation id, Supplier<Block> leaves, @Nullable Supplier<WoodType> wood) {
            this(id, leaves);
        }

        @Deprecated(forRemoval=true)
        public Finder(ResourceLocation id, Supplier<Block> leaves) {
            super(id);
            this.leavesFinder = leaves;
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(String modId, String leavesTypeName, String leavesName) {
            return new Finder(new ResourceLocation(modId, leavesTypeName), () -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(modId, leavesName)), null);
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(String modId, String leavesTypeName, String leavesName, String woodTypeID) {
            ResourceLocation leavesId = new ResourceLocation(modId, leavesName);
            LeavesTypeRegistry.INSTANCE.addLeavesToWoodMapping(leavesId, new ResourceLocation(woodTypeID));
            return new Finder(new ResourceLocation(modId, leavesTypeName), () -> (Block)BuiltInRegistries.f_256975_.m_7745_(leavesId));
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, String childName) {
            this.addChild(childType, new ResourceLocation(this.id.m_135827_(), childName));
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, ResourceLocation childName) {
            this.childBlock(childType, childName);
        }
    }
}

